import { StyleSheet, Text, View } from "react-native";
import React from "react";
import R from "../../assets/R";

const ItemNav = ({ item }) => {
  return (
    <View style={styles.container}>
      <Text style={styles.text}>{item.address}</Text>
      <Text style={[styles.text,{fontFamily:R.fonts.InterMedium}]}>Thời gian cứ trú:{' '}
        <Text style={[styles.text,{fontFamily:R.fonts.InterRegular}]}>{item.timeStay}</Text></Text>
      <View style={{ flexDirection: "row", justifyContent: "space-between"}}>
        <Text style={[styles.text, { fontFamily:R.fonts.InterMedium }]}>Ngày đăng kí:{' '}
          <Text style={[styles.text,{fontFamily:R.fonts.InterRegular}]}>
            {item.registrationDate}</Text></Text>
        <View style={[styles.text, { fontFamily:R.fonts.InterRegular }]}>
          <Text
            style={[
              styles.text,
              {alignSelf:'flex-end'},
              item.statusColor && { color: item.statusColor },
            ]}
          >
            {item.status}
          </Text>
        </View>
      </View>
      <Text style={[styles.text, { fontFamily:R.fonts.InterMedium }]}>Quan hệ với chủ trọ:{' '}
        <Text style={[styles.text,{fontFamily:R.fonts.InterRegular}]}>{item.relation}</Text></Text>
      <Text style={[styles.text, { fontFamily:R.fonts.InterMedium }] }>Lý do:{' '}
        <Text style={[styles.text,{fontFamily:R.fonts.InterRegular}]}>{item.reason}</Text></Text>
    </View>
  );
};

export default ItemNav;

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white ,
    borderRadius: 15,
    marginBottom: 7.5,
    padding: 10,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  
  text: {
    fontSize: R.fontsize.fontsSize12,
    fontWeight: "600",
    color: R.colors.black,
    fontFamily: R.fonts.InterMedium,
  },
});
