
import R from "../../assets/R";
import { Text, View, TouchableOpacity, StyleSheet, Image } from 'react-native';

const ItemView = ({item}) => {
  return (
    <TouchableOpacity style={styles.container}>
        <Text style={styles.text_title}>Mã môn học:
          <Text style={styles.text_content}> {item.code_exam}</Text>
        </Text>
        <Text style={styles.text_title}>Mã lớp:
          <Text style={styles.text_content}> {item.code_class}</Text>
        </Text>

        <View style={styles.content}>
            <Text style={styles.text_title}>Ca/Tiết thi: 
              <Text style={styles.text_content}> {item.poetry}</Text>
            </Text>
            <Text style={styles.text_title}>Thứ thi:
              <Text style={styles.text_content}> {item.day_exam}</Text>
            </Text>
        </View>
        <View style={styles.content}>
            <Text style={styles.text_title}>Ngày thi:
              <Text style={styles.text_content}> {item.time_exam}</Text>
            </Text>
            <Text style={styles.text_title}>Phòng thi:
              <Text style={styles.text_content}> {item.class_exam}</Text>
            </Text>
        </View>
        <Text style={styles.text_title}>Ghi chú/ hình thức thi:
          <Text style={styles.text_content}> {item.description}</Text>
        </Text>

    </TouchableOpacity>
  );
};

export default ItemView;
const styles = StyleSheet.create({
  container: {
    borderRadius: 10,
    paddingHorizontal: 14,
    paddingVertical: 10,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 1,
    elevation: Platform.OS === 'ios' ? 1 : 2,
    backgroundColor: R.colors.white,
    marginHorizontal:10,
    marginVertical:7.5
  },
  content: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
  },
  text_title: {
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '600',
    color: R.colors.black,
    fontFamily: R.fonts.InterMedium,
  },
  text_content: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.black,
    fontWeight: '400',
    fontFamily: R.fonts.InterRegular,
  },
});
