import {StyleSheet, Dimensions} from 'react-native';
import R from '../../../assets/R';

const {width: screenWidth, height: screenHeight} = Dimensions.get('window');
const HOUR_HEIGHT = 80;

const styles = StyleSheet.create({
  // ==================== CONTAINER CHÍNH ====================
  // Tương ứng với View chính trong FilterDayView dòng 117
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },

  // ==================== MONTH PICKER ====================
  // Tương ứng với renderMonthPicker dòng 25-27
  monthPickerContainer: {
    backgroundColor: R.colors.white,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray220,
    paddingVertical: 10,
  },
  monthPickerContent: {
    paddingHorizontal: 15,
  },
  monthItem: {
    paddingHorizontal: 20,
    paddingVertical: 8,
    marginRight: 10,
    borderRadius: 20,
    backgroundColor: R.colors.gray220,
  },

  // ==================== DATE INFO CONTAINER ====================
  // Tương ứng với renderDateInfo dòng 29-43
  dateInfoContainer: {
    paddingHorizontal: 15,
    paddingVertical: 12,
    alignItems: 'center',
    justifyContent: 'center',
    maxWidth: 70,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray220,
  },
  dayName: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterMedium,
    color: R.colors.black,
    fontWeight: '600',
    marginBottom: 2,
  },
  dayNumber: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
    fontWeight: '400',
  },
  dayNumberToday: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.white,
    fontWeight: '400',
    backgroundColor: R.colors.main,
    borderRadius: 15,
    paddingHorizontal: 8,
    paddingVertical: 4,
  },

  // ==================== TIME SLOTS CONTAINER ====================
  // Tương ứng với renderTimeSlots dòng 45-115
  timeSlotsContainer: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  scrollContent: {
    paddingBottom: 50,
  },
  timelineContainer: {
    flexDirection: 'row',
    position: 'relative',
  },

  // ==================== TIME LABELS COLUMN ====================
  // Tương ứng với timeLabelsColumn dòng 56-65
  timeLabelsColumn: {
    minWidth: 70,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray220,
  },
  timeSlot: {
    height: HOUR_HEIGHT,
    alignItems: 'center',
    justifyContent: 'center',
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray220,
  },
  timeText: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
    fontWeight: '400',
  },

  // ==================== EVENTS COLUMN ====================
  // Tương ứng với eventsColumn dòng 67-110
  eventsColumn: {
    flex: 1,
    position: 'relative',
    height: 24 * HOUR_HEIGHT,
  },
  gridLine: {
    height: HOUR_HEIGHT,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray220,
    width: '100%',
  },

  // ==================== EVENT CARDS ====================
  // Tương ứng với event rendering dòng 72-109
  eventCard: {
    borderRadius: 15,
    paddingHorizontal: 8,
    paddingVertical: 4,
    justifyContent: 'flex-start',
  },
  eventTitle: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.white,
    fontWeight: '400',
    marginBottom: 5,
  },
  eventSubtitle: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    color: R.colors.white,
    marginBottom: 5,
  },
  eventTime: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.white,
    fontWeight: '400',
  },
});

export default styles;
