import React from "react";
import {
  Text,
  View,
  StyleSheet,
  ScrollView,
  SafeAreaView
} from "react-native";
import CheckBox from "../../components/CheckBox";
import Header from "../../components/Header/Header";
import I18n from "../../helper/i18/i18n";
import R from "../../assets/R";
import Button from "../../components/Button";
import CardButtonImage from "./card_button";
import DropdownSelect from "../../components/Dropdown/DropdownSel";
import CustomTextInput from "../../components/Input/TextFieldCus";

const CertificateRegistrationView = (props) => {
  const { titleHeader, dataList, isSelected, setSelection } = props;
  return (
    <View style={{ flex: 1, }}>
      <Header isBack title={I18n.t(titleHeader)} />
      <ScrollView
        showsVerticalScrollIndicator={false}
        contentContainerStyle={styles.scrollContent}>
        <View style={styles.container}>


          <DropdownSelect
            title={"Loại chứng chỉ *"}
            data={dataList}
            placeholder="HS"
            placeholderFontFamily={R.fonts.InterRegular}
            placeholderFontSize={R.fontsize.fontsSize12}
            placeholderFontWeight={"400"}
            placeholderColor={R.colors.grey}
            borderRadius={10}
            height={30}
            marginHorizontal={15}
            marginVertical={5}
            iconColor={R.colors.black}
            iconSize={5}
          />
          <View style={{ marginHorizontal: 15, }}>
            <CustomTextInput
              title={"Ngày sinh "}
              backgroundColor={R.colors.gray400}
              editable={false}

            />
          </View>
          <View style={{ marginHorizontal: 15 }}>
            <CustomTextInput
              title={"CMND/CCCD (thí sinh dùng để đăng ký thi)"}
              backgroundColor={R.colors.gray400}
              editable={false}
            />
          </View>

          <View style={styles.container_row}>
            <View style={{ flex: 1, marginLeft: 15 }}>
              <CustomTextInput
                title={"Điểm nghe "}
              />
            </View>
            <View style={{ width: '3%' }}></View>
            <View style={{ flex: 1, marginRight: 15 }}>
              <CustomTextInput
                title={"Điểm nói "}
              />
            </View>
          </View>

          <View style={styles.container_row}>
            <View style={{ flex: 1, marginLeft: 15 }}>
              <CustomTextInput
                title={"Điểm đọc"}
              />
            </View>
            <View style={{ width: '3%' }}></View>
            <View style={{ flex: 1, marginRight: 15 }}>
              <CustomTextInput
                title={"Điểm viết "}
              />
            </View>
          </View>

          <View
            style={styles.container_row}
          >
            <View style={{ flex: 0.85, marginBottom: 10, marginHorizontal: 15 }}>
              <CustomTextInput
                title={"Tổng điểm "}
              />
            </View>
            <CheckBox
              label={"Đăng kí học bổng"}
              titleFontFamily={R.fonts.InterRegular}
              titleFontSize={R.fontsize.fontsSize12}
              titleFontWeight={"300"}
              borderRadius={30}
              size={15}
              labelStyle={{
                fontSize: R.fontsize.fontsSize12,
                fontWeight: "300",
                color: R.colors.black,
                fontFamily: R.fonts.InterRegular,
              }}
              style={{ marginTop: 15, flex: 1 }}
            />
          </View>

          <View style={styles.container_row_body}>
            <CustomTextInput
              title={"Ngày thi "}

            />
          </View>

          <View style={styles.container_row_body}>
            <CustomTextInput
              title={"Có hiệu lực đến"}

            />
          </View>
          <View style={styles.container_row_body}>
            <CustomTextInput
              title={"Số TRF"}

            />
          </View>

          <Text style={{ marginHorizontal: 15, color: R.colors.black, fontSize: R.fontsize.fontsSize12, fontWeight: "600", fontFamily: R.fonts.InterMedium }}>
            Ảnh chứng chỉ <Text style={{ color: "red" }}>*</Text>
          </Text>
          <CardButtonImage />

          <View style={styles.footer}>
            <CheckBox
              value={isSelected}
              onValueChange={setSelection}
              borderRadius={10}
              marginLeft={15}

            />
            <Text style={styles.text_footer}>
              "Tôi xin cam đoan rằng chứng chỉ mà tôi đã nộp là chứng chỉ hoàn
              toàn hợp lệ và có giá trị pháp lý. Nếu phát hiện bất kỳ sai phạm
              nào liên quan đến tính xác thực của chứng chỉ, tôi xin hoàn toàn
              chịu trách nhiệm và chấp nhận mọi hình thức xử lý theo quy định,
              bao gồm cả việc bị buộc thôi học và cấm thi vào trường Đại học
              Công nghệ Thông tin (UIT) trong thời hạn 5 năm."
            </Text>
          </View>

          <Button
            title="Thanh toán"
            marginHorizontal={15}
            fontSize={R.fontsize.fontSizeContent}
            fontWeight={300}
            fontFamily={R.fonts.InterRegular}
            textStyle={styles.text_button}
            backgroundColor={R.colors.buttonColorSel}
            textColor={R.colors.white}
            borderRadius={10}
            paddingVertical={4}
            height={35}
          />
        </View>
      </ScrollView>
    </View>
  );
};

export default CertificateRegistrationView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  container_row: {
    flexDirection: 'row'
  },
  container_row_body: {
    marginHorizontal: 15,
  },
  footer: {
    flexDirection: "row",
    marginBottom: 84,
    marginRight: 15
  },
  text_footer: {
    marginLeft: 10,
    flex: 1,
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.black,
    fontWeight: '400'
  }
});
