import React from "react";
import { useNavigation } from "@react-navigation/native";
import {
  Text,
  View,
  StyleSheet,
  ScrollView,
  SafeAreaView,
} from "react-native";
import Header from "../../../components/Header/Header";
import Button from "../../../components/Button";
import R from "../../../assets/R";
import ItemNav from "./item";
import { CERTIFICATEREGISTRATION } from "../../../routers/ScreenNames";

const ListCetificateView = (props) => {
  const { } = props;
  const navigate = useNavigation();
  return (
    <View style={{flex:1, }}>
        <Header isBack={true} isSearch={true} title={"Danh sách chứng chỉ"}
     />
      <ScrollView style={styles.container}>
          <View style={styles.container_header}>
            <Text style={styles.text}>Các chứng chỉ đã đăng kí</Text>
            <Button
              onPress={() => navigate.navigate(CERTIFICATEREGISTRATION)}
              height={35}
              borderRadius={10}
              textColor={R.colors.white}
              fontFamily={R.fonts.InterRegular}
              fontWeight={300}
              fontSize={R.fontsize.fontsSize12}
              iconSpacingLeft={2}
              paddingHorizontal={10}
              icon={R.images.icPlus}
              backgroundColor={R.colors.blue500}
              title={"Thêm mới"}
            />
          </View>
          <View style={styles.container_item}>
            <ItemNav />
          </View>

      </ScrollView>
    </View>
  );
};

export default ListCetificateView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    paddingBottom: 10,
    backgroundColor: R.colors.white,
  },
  container_header: {
    alignItems: "center",
    justifyContent: "space-between",
    flexDirection: "row",
    marginVertical: 10,
    marginHorizontal: 15,
  },
  text: {
    fontFamily: R.fonts.InterSemiBold,
    color: R.colors.main,
  },
  container_item: {
    marginHorizontal: 15,
  },
});
