import React, { useEffect, useState } from 'react';
import { DeviceEventEmitter, Image, View } from 'react-native';
import { createBottomTabNavigator } from '@react-navigation/bottom-tabs';
import i18n from '../helper/i18/i18n';
import { connect } from 'react-redux';
import R from '../assets/R';
import { StyleSheet , Platform} from 'react-native';

import Home from '../screens/home';
import ELearning from '../screens/elearning';
import QrCode from '../screens/qrcode';
import Notification from '../screens/notification';
import Profile from '../screens/profile';
const Tab = createBottomTabNavigator();

const TabNavigator = props => {
  const [reload, setReload] = useState(false);
 
  useEffect(() => {
    let setLanguage = DeviceEventEmitter.addListener('setLanguage', value => {
      setReload(!reload);
    });
    return () => {
      setLanguage.remove();
    };
  }, []);
  return (
    <Tab.Navigator
      initialRouteName="Screen5"
      screenOptions={{
        headerShown: false,
        tabBarStyle: {
          height: Platform.OS === 'ios' ? 80 : 61, // 👈 Tăng chiều cao ở đây
          paddingVertical: Platform.OS === 'ios' ? 10 : 5, // 👈 Tăng padding nếu icon/text bị sát mép dưới
        },
        tabBarActiveTintColor: R.colors.blue500, // active icon/text
        tabBarShowLabel: true,
        tabBarLabelStyle: {
          fontSize: R.fontsize.fontsSize10,
          fontWeight: "400",
          fontFamily: R.fonts.InterRegular,
        },

        tabBarShowIcon: true,
      }}
    >
      <Tab.Screen
        name="HomeScreen1"
        component={Home}
        options={{
          tabBarLabel: i18n.t('Home'),
          tabBarIcon: ({ focused }) => (
            <Image
              source={focused ? R.images.icHomeSel : R.images.icHomeUnSel}
              style={styles.tabBarIcon}
            />
          ),
        }}
      />

      <Tab.Screen
        name="Elearning"
        component={ELearning}
        options={{
          tabBarLabel: i18n.t('Elearning'),
          tabBarIcon: ({ focused }) => (
            <Image
              source={focused ? R.images.icELearing : R.images.icELearingUnSel}
              style={styles.tabBarIcon}
            />
          ),
        }}
      />
      <Tab.Screen
        name="QRScreen"
        component={QrCode}
        options={{
          tabBarLabel: i18n.t('QrCode'),
          tabBarIcon: ({ focused }) => (
            <Image
              source={focused ? R.images.icQrCode : R.images.icQrCodeUnSel}
              style={styles.tabBarIcon}
            />
          ),
        }}
      />
      <Tab.Screen
        name="Notification"
        component={Notification}
        options={{
          tabBarLabel: i18n.t('Notification'),
          tabBarIcon: ({ focused }) => (
            <Image
              source={focused ? R.images.icNotification : R.images.icNotificationUnSel}
              style={styles.tabBarIcon}
            />
          ),
        }}
      />
      <Tab.Screen
        name="Profile"
        component={Profile}
        options={{
          tabBarLabel: i18n.t('Profile'),
          tabBarIcon: ({ focused }) => (
            <Image
              source={focused ? R.images.icProfile : R.images.icProfileUn}
              style={styles.tabBarIcon}
            />
          ),
        }}
      />
    </Tab.Navigator>
  );
};

const mapStateToProps = state => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {})(TabNavigator);

const styles = StyleSheet.create({
    tabBarIcon: {
      width: Platform.OS === 'ios' ? 20: 25,
      height: Platform.OS === 'ios' ? 20 : 25,
        resizeMode: 'contain'
    }
});