import React from "react";
import {
  View,
  StyleSheet,
  FlatList,
  SafeAreaView,
} from "react-native";
import R from "../../assets/R";
import Header from "../../components/Header/Header";
import ItemView from "./item_view";

const TrainingProgramView = (props) => {
  const { dataTrainingProgram} = props;
  const renderContent = ({ item }) => {
    return (
      <ItemView
        item={item}
        hasContentFlag={item.hasContentFlag}
        processedContent={item.processedContent}
      />
    );
  };
  return (
    <View style={styles.container}>
         <Header isBack title={"Chương trình đào tạo"} />
    <View style={styles.container}>
   
      <View>
        <FlatList
          data={dataTrainingProgram}
          renderItem={renderContent}
          keyExtractor={(item) => item.id}
          showsVerticalScrollIndicator={false}
          removeClippedSubviews={true}
          maxToRenderPerBatch={10}
          windowSize={10}
        />
      </View>
    </View>
    </View>
  );
};

export default TrainingProgramView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor:R.colors.white
  },
});
