import React from 'react';
import {View, FlatList, SafeAreaView } from 'react-native';
import Header from "../../components/Header/Header";
import I18n from "../../helper/i18/i18n";
import ItemView from "./item_view";
import styles from './style';
import ItemCalendar from '../roll_call/item_calendar';
const ExamScheduleView = (props) => {
  const {dataExamSchedule} = props;
  const renderContent = ({ item }) => {
    return (
      <ItemView
        item={item}
      />
    );
  };
  return (
    <View style={styles.container}>
      <Header isBack title={I18n.t("ExamSchedule")} />
    <View style={styles.container}>
      
      <ItemCalendar/>
      <View style={styles.flatlist}>
        <FlatList
          data={dataExamSchedule}
          renderItem={renderContent}
          keyExtractor={(item) => item.id}
          showsVerticalScrollIndicator={false}
        />
      </View>
    </View>
    </View>
  );
};

export default ExamScheduleView;

