import React from 'react';
import {Text, View, StyleSheet, ScrollView, SafeAreaView} from 'react-native';
import CheckBox from '../../components/CheckBox';
import Header from '../../components/Header/Header';
import I18n from '../../helper/i18/i18n';
import R from '../../assets/R';
import Button from '../../components/Button';
import CardButtonImage from './card_button';
import DropdownSelect from '../../components/Dropdown/DropdownSel';
import CustomTextInput from '../../components/Input/TextFieldCus';
import styles from './style';

const CertificateRegistrationView = props => {
  const {titleHeader, dataList, isSelected, setSelection} = props;
  const renderBody = () => {
    return (
      <ScrollView
        showsVerticalScrollIndicator={false}
        contentContainerStyle={styles.scrollContent}>
        <View style={styles.container}>
          <DropdownSelect
            title={'Loại chứng chỉ *'}
            titleFontFamily={R.fonts.InterRegular}
            titleFontSize={R.fontsize.fontsSize12}
            titleFontWeight={'800'}
            titleColor={R.colors.black}
            data={dataList}
            placeholder="HS"
            placeholderFontFamily={R.fonts.InterRegular}
            placeholderFontSize={R.fontsize.fontsSize12}
            placeholderFontWeight={'400'}
            placeholderColor={R.colors.grey}
            borderRadius={10}
            height={35}
            marginHorizontal={15}
            marginVertical={10}
            iconColor={R.colors.black}
            iconSize={10}
          />
          <View style={styles.size_box_2}>
            <CustomTextInput
              title={'Ngày sinh '}
              backgroundColor={R.colors.gray400}
              editable={false}
              height={35}
              containerMarginBottom={10}
            />
          </View>
          <View style={styles.size_box_2}>
            <CustomTextInput
              title={'CMND/CCCD (thí sinh dùng để đăng ký thi)'}
              backgroundColor={R.colors.gray400}
              editable={false}
              height={35}
              containerMarginBottom={10}
            />
          </View>

          <View style={[styles.container_row, {marginRight: 15}]}>
            <View style={styles.size_box_3}>
              <CustomTextInput
                title={'Điểm nghe '}
                height={35}
                onChangeText={text => console.log(text)}
                containerMarginBottom={10}
              />
            </View>
            <View style={styles.size_box_4}></View>
            <View style={styles.size_box_3}>
              <CustomTextInput
                title={'Điểm nói '}
                height={35}
                onChangeText={text => console.log(text)}
                containerMarginBottom={10}
              />
            </View>
          </View>

          <View style={styles.container_row}>
            <View style={styles.size_box_3}>
              <CustomTextInput title={'Điểm đọc'} height={35} containerMarginBottom={10}/>
            </View>
            <View style={styles.size_box_4}></View>
            <View style={[styles.size_box_3, {marginRight: 15}]}>
              <CustomTextInput title={'Điểm viết'} height={35} containerMarginBottom={10}/>
            </View>
          </View>

          <View style={styles.container_row}>
            <View style={{flex: 0.85, marginLeft: 15}}>
              <CustomTextInput title={'Tổng điểm '} height={35} containerMarginBottom={10}/>
            </View>
            <CheckBox
              label={'Đăng kí học bổng'}
              titleFontFamily={R.fonts.InterRegular}
              titleFontSize={R.fontsize.fontsSize12}
              titleFontWeight={'300'}
              borderRadius={30}
              size={15}
              labelStyle={{
                fontSize: R.fontsize.fontsSize12,
                fontWeight: '800',
                color: R.colors.black,
                fontFamily: R.fonts.InterRegular,
              }}
              style={styles.size_box_3}
            />
          </View>

          <View style={styles.container_row_body}>
            <CustomTextInput title={'Ngày thi '} height={35} containerMarginBottom={10}/>
          </View>

          <View style={styles.container_row_body}>
            <CustomTextInput title={'Có hiệu lực đến'} height={35} containerMarginBottom={10}/>
          </View>
          <View style={styles.container_row_body}>
            <CustomTextInput title={'Số TRF'} height={35} containerMarginBottom={10}/>
          </View>

          <Text style={styles.text_title_register}>
            Ảnh chứng chỉ <Text style={{color: 'red',}}>*</Text>
          </Text>
          <CardButtonImage />

          <View style={styles.footer}>
            <CheckBox
              value={isSelected}
              onValueChange={setSelection}
              borderRadius={10}
              marginLeft={15}
            />
            <Text style={styles.text_footer}>
              "Tôi xin cam đoan rằng chứng chỉ mà tôi đã nộp là chứng chỉ hoàn
              toàn hợp lệ và có giá trị pháp lý. Nếu phát hiện bất kỳ sai phạm
              nào liên quan đến tính xác thực của chứng chỉ, tôi xin hoàn toàn
              chịu trách nhiệm và chấp nhận mọi hình thức xử lý theo quy định,
              bao gồm cả việc bị buộc thôi học và cấm thi vào trường Đại học
              Công nghệ Thông tin (UIT) trong thời hạn 5 năm."
            </Text>
          </View>

          <Button
            title="Thanh toán"
            marginHorizontal={15}
            fontSize={R.fontsize.fontSizeContent}
            fontWeight={300}
            fontFamily={R.fonts.InterRegular}
            textStyle={styles.text_button}
            backgroundColor={R.colors.buttonColorSel}
            textColor={R.colors.white}
            borderRadius={10}
            paddingVertical={4}
          />
        </View>
      </ScrollView>
    );
  };
  return (
    <View style={styles.size_box}>
      <Header isBack title={I18n.t(titleHeader)} />
      {renderBody()}
    </View>
  );
};

export default CertificateRegistrationView;
