import {StyleSheet, Text, View, TouchableOpacity, Image} from 'react-native';
import React from 'react';
import R from '../../assets/R';
import styles from './style';
const CardButtonImage = ({
  onPress,
  text = 'Tải ảnh ở đây',
  width,
  height = 150,
  disabled = false,
}) => {
  return (
    <TouchableOpacity
      style={[
        styles.container_image,
        {width, height},
        disabled && styles.disabled,
      ]}
      onPress={onPress}
      disabled={disabled}
      activeOpacity={0.7}>
      <View style={styles.image_placeholder}></View>
      <View>
        <Image source={R.images.icImageDownload} style={styles.image} />
      </View>
      <Text style={styles.placeholder_text}>{text}</Text>
    </TouchableOpacity>
  );
};

export default CardButtonImage;
