import React, { useMemo, useState } from 'react';
import {Text, View, StyleSheet} from 'react-native';
import DetailRollCallView from './view';
import R from '../../../assets/R';

const DetailRollCall = (props) => {
    const [dataListInfo,setDataListInfo] = useState([
        {serial_number:'1', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'2', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Vắng mặt',note:''},
        {serial_number:'3', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'4', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'5', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'6', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'7', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'8', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'9', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'10', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'11', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'12', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'13', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'14', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'15', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'16', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'17', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'18', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'19', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'20', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'21', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'22', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'23', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'24', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'25', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'26', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'27', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'28', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'29', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
        {serial_number:'30', study_day:'10/07/2025',study_time:"7:30-9:30", checked_by:'ducnm',attendance_status:'Có mặt',note:''},
    ])
    // const dataList = dataListInfo.map(item => [
    //     item.serial_number,
    //     item.study_day,
    //     item.study_time,
    //     item.checked_by,
    //     item.attendance_status,
    //     item.note
    // ]);
    const [dataTitle,setDataTitle] = useState([
        'STT','Ngày học','Thời gian học', 'Người điểm danh', 'Trạng thái', 'Ghi chú'
    ])
    const getStatusColor = (attendanceStatus) => {
    switch (attendanceStatus) {
      case 'Có mặt':
        return R.colors.green;
      case 'Vắng mặt':
        return R.colors.red ;
      default:
        return R.colors.black;
    }
  };
   const processedTableData = useMemo(() => {
    return dataListInfo.map((item, rowIndex) => {
      return [
        {
          content: item.serial_number,
        },
        {
          content: item.study_day,
        },
        {
          content: item.study_time,
        },
        {
          content: item.checked_by,
        },
        {
          content: item.attendance_status,
          style: { 
            color: getStatusColor(item.attendance_status),
            fontWeight: '400' 
          }
        },
        {
          content: item.note,
        }
      ];
    });
  }, [dataListInfo]);

  const handleRowPress = (rowIndex) => {
    console.log('Row pressed:', rowIndex);
  };
  return (
    <DetailRollCallView 
        dataTitle={dataTitle}
        dataListInfo={processedTableData}
        handleRowPress={handleRowPress}
    />
  );
};

export default DetailRollCall;
