import React from "react";
import {
  Text,
  View,
  StyleSheet,
  ScrollView,
  SafeAreaView,
} from "react-native";
import Header from "../../components/Header/Header";
import R from "../../assets/R";
import DropdownSelect from "../../components/Dropdown/DropdownSel";
import CardButtonImage from "./card_button";
import Button from "../../components/Button";
import CustomTextInput from "../../components/Input/TextFieldCus";

const MedicalView = (props) => {
  return (
    <View style={[styles.container, { paddingHorizontal: 0, paddingTop: 0 }]}>
      <Header title={"Thông tin y tế"} isBack />
      <ScrollView showsVerticalScrollIndicator={false} style={{ paddingHorizontal: 15 }}>
        <Text style={styles.title_header}>Thông tin bảo hiểm y tế</Text>
        <CustomTextInput
          title={"Mã BHYT hoặc BHXH"}
          required={true}

        />
        <DropdownSelect
          title={"Loại thẻ BHYT *"}
          titleMarginBottom={3}
          marginHorizontal={0}
          placeholder="Khác"
          placeholderColor={R.colors.grey_800}
          borderRadius={10}
          height={40}
          iconColor={R.colors.black}
          titleFontWeight={"300"}
          fontSize={R.fontsize.fontsSize12}
          titleFontSize={R.fontsize.fontsSize12}
          titleFontFamily={R.fonts.InterRegular}
        />
        <CustomTextInput
          title={"Ngày hết hạn BHYT"}
          required={true}
        />
        <Text style={styles.title_input}>
          Hình chụp mặt trước BHYT, hoặc hình chụp kết quả tra cứu thẻ BHXH{" "}
          <Text style={{ color: R.colors.red }}>*</Text>
        </Text>

        <CardButtonImage />
        <Text style={styles.title_input}>
          Hình chụp kết quả tra cứu hạn thẻ BHYT{" "}
          <Text style={{ color: R.colors.red }}>*</Text>
        </Text>
        <CardButtonImage />

        <DropdownSelect
          title={
            "  Đăng ký nơi khám chữa bệnh ban đầu theo BHYT khi học tại trường *"
          }
          placeholder="HS"
          placeholderColor={R.colors.grey_800}
          borderRadius={10}
          height={40}
          iconColor={R.colors.black}
          titleFontWeight={"300"}
          fontSize={R.fontsize.fontsSize12}
          titleFontSize={R.fontsize.fontsSize12}
          titleFontFamily={R.fonts.InterRegular}
          marginBottom={50}
          marginHorizontal={0}
          marginVertical={0}
        />
        <Button
          title={"Cập nhật"}
          titleFontFamily={R.fonts.InterSemiBold}
          titleFontSize={R.fontsize.fontsSize14}
          titleFontWeight={"600"}
          backgroundColor={R.colors.blue500}
          borderRadius={10}
          textColor={R.colors.white}
          height={40}
          marginBottom={15}
          marginHorizontal={0}
          marginVertical={0}
        />
      </ScrollView>
    </View>
  );
};

export default MedicalView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  title_header: {
    color: R.colors.blue500,
    fontFamily: R.fonts.InterSemiBold,
    fontWeight: "600",
    fontSize: R.fontsize.fontsSize14,
  },
  title_input: {
    titleFontWeight: "300",
    fontSize: R.fontsize.fontsSize12,
    titleFontSize: R.fontsize.fontsSize12,
    titleFontFamily: R.fonts.InterRegular,
    color: R.colors.black,
  },
});
