import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  ScrollView,
  SafeAreaView,
  LogBox,
} from 'react-native';
import R from '../../assets/R';
import {styles} from './style';
import {monthNames, weekDays, formatDateToString} from '../../config/Functions';
import ModalBottomSheetView from './modal_bottom_sheet';
LogBox.ignoreAllLogs(true);
const ClassScheduleView = ({
  selectedDate,
  showBottomSheet,
  bottomSheetTranslateY,
  panResponder,
  calendarPanResponder,
  getMonthData,
  getEventsForDate,
  parseLocalDate,
  formatDateToDisplay,
  isCurrentMonth,
  isToday,
  navigateMonth,
  handleDatePress,
  handleEventPress,
  handleCloseBottomSheet,
  getSelectedEvents,
}) => {
  const renderHeader = () => {
    return (
      <View style={styles.header}>
        <TouchableOpacity
          style={styles.navButton}
          onPress={() => navigateMonth('prev')}>
          <Text style={styles.navButtonText}>‹</Text>
        </TouchableOpacity>

        <Text style={styles.header_title}>
          {monthNames[getMonthData.month]} {getMonthData.year}
        </Text>

        <TouchableOpacity
          style={styles.navButton}
          onPress={() => navigateMonth('next')}>
          <Text style={styles.navButtonText}>›</Text>
        </TouchableOpacity>
      </View>
    );
  };

  const renderWeekDays = () => {
    return (
      <View style={styles.weekDaysContainer}>
        {weekDays.map((day, index) => (
          <View key={index} style={styles.weekDayCell}>
            <Text style={styles.weekDayText}>{day}</Text>
          </View>
        ))}
      </View>
    );
  };

  const renderDayCell = (date, index) => {
    const dayEvents = getEventsForDate(date);
    const isSelected = selectedDate === formatDateToString(date);
    const isTodayDate = isToday(date);
    const isInCurrentMonth = isCurrentMonth(date);

    return (
      <TouchableOpacity
        key={index}
        style={[
          styles.dayCell,
          !isInCurrentMonth && styles.dayCellInactive, // Thêm background cho ngày khác tháng
          isSelected && styles.selectedDayCell,
          isTodayDate && styles.todayCell,
        ]}
        onPress={() => handleDatePress(date)}
        activeOpacity={0.7}>
        <Text
          style={[
            styles.dayText,
            !isInCurrentMonth && styles.dayTextInactive,
            isSelected && styles.selectedDayText,
            isTodayDate && styles.todayText,
          ]}>
          {date.getDate()}
        </Text>

        {dayEvents.length > 0 && (
          <View style={styles.eventsContainer}>
            {dayEvents.slice(0, 2).map((event, eventIndex) => (
              <TouchableOpacity
                key={event.id}
                style={[styles.eventBar, {backgroundColor: R.colors.main}]}
                onPress={() => handleEventPress(event)}>
                <Text style={styles.eventBarText} numberOfLines={1}>
                  {event.title}
                </Text>
              </TouchableOpacity>
            ))}
            {dayEvents.length > 2 && (
              <Text style={styles.moreEventsText}>+{dayEvents.length - 2}</Text>
            )}
          </View>
        )}
      </TouchableOpacity>
    );
  };

  const renderCalendarGrid = () => {
    const weeks = [];
    for (let i = 0; i < 6; i++) {
      const week = getMonthData.days.slice(i * 7, (i + 1) * 7);
      weeks.push(
        <View key={i} style={styles.weekRow}>
          {week.map((date, dayIndex) => renderDayCell(date, i * 7 + dayIndex))}
        </View>,
      );
    }
    return <View style={styles.calendarGrid}>{weeks}</View>;
  };

  return (
    <SafeAreaView style={styles.container}>
      <ScrollView showsVerticalScrollIndicator={false}>
        <View>
          {renderHeader()}
          {renderWeekDays()}
          <View 
            style={styles.calendarGrid}
            {...(calendarPanResponder?.panHandlers || {})}>
            {renderCalendarGrid()}
          </View>
          
        </View>
      </ScrollView>

      <ModalBottomSheetView
        selectedDate={selectedDate}
        showBottomSheet={showBottomSheet}
        bottomSheetTranslateY={bottomSheetTranslateY}
        panResponder={panResponder}
        parseLocalDate={parseLocalDate}
        formatDateToDisplay={formatDateToDisplay}
        handleCloseBottomSheet={handleCloseBottomSheet}
        getSelectedEvents={getSelectedEvents}
      />
    </SafeAreaView>
  );
};

export default ClassScheduleView;
