import {StyleSheet, Dimensions} from 'react-native';
import R from '../../assets/R';
const {width, height} = Dimensions.get('window');

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  container_row: {
    flexDirection: 'row',
  },
  container_row_body: {
    marginHorizontal: 15,
  },
  footer: {
    flexDirection: 'row',
    marginBottom: 84,
    marginRight: 15,
  },
  text_footer: {
    marginLeft: 10,
    flex: 1,
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.black,
    fontWeight: '400',
  },
  size_box: {
    flex: 1,
  },
  size_box_2: {
    marginHorizontal: 15,
  },
  size_box_3: {
    flex: 1,
    marginLeft: 15,
  },
  size_box_4: {
    width: '3%',
  },

  container_image: {
    justifyContent: 'center',
    alignItems: 'center',
    marginHorizontal: 15,
    marginTop: 3,
    marginBottom: 15,
    borderWidth: 1,
    borderColor: R.colors.blue500,
    borderStyle: 'dashed',
    borderRadius: 15,
    backgroundColor: R.colors.white,
    padding: 16,
    flexDirection: 'row',
    flex: 1,
  },

  image: {
    width: 20,
    height: 20,
    marginRight: 5,
    marginTop: 5,
  },

  image_placeholder: {
    position: 'absolute',
    width: '100%',
    height: '100%',
    borderRadius: 10,
  },

  placeholder_text: {
    fontSize: R.fontsize.fontsSize14,
    fontWeight: '500',
    color: R.colors.black,
    textAlign: 'center',
    letterSpacing: 0.3,
  },

  disabled: {
    opacity: 0.5,
    backgroundColor: R.colors.gray400,
  },
  /* -------------------------------------------------------------------------- */
  /*                             Danh sách chứng chỉ                            */
  /* -------------------------------------------------------------------------- */
  box: {
    flex: 1,
    paddingBottom: 10,
    backgroundColor: R.colors.white,
  },
  container_header: {
    alignItems: 'center',
    justifyContent: 'space-between',
    flexDirection: 'row',
    marginVertical: 10,
    marginHorizontal: 15,
  },
  text: {
    fontFamily: R.fonts.InterSemiBold,
    color: R.colors.main,
  },
  container_item: {
    marginHorizontal: 15,
  },
  /* -------------------------------------------------------------------------- */
  /*                               Item chứng chỉ                               */
  /* -------------------------------------------------------------------------- */
  container_card: {
    borderRadius: 15,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    marginVertical: 5,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.5,
    shadowRadius: 1,
    elevation: 1,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  button_container: {
    alignSelf: 'flex-end',
  },
  header_card_item: {
    justifyContent: 'space-between',
    flexDirection: 'row',
  },
  footer_card_item: {
    justifyContent: 'space-between',
    flexDirection: 'row',
  },
  image_item: {
    maxWidth: '100%',
    maxHeight: 200,
    resizeMode: 'contain',
  },
  image_container: {
    maxWidth: 340,
    maxHeight: 200,
    alignSelf: 'center',
  },
  text_title_left: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize14,
    fontWeight: '400',
    color: R.colors.black,
  },
  text_title_right: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize14,
    fontWeight: '400',
    textDecorationLine: 'underline',
    color: R.colors.main,
  },
  sub_text: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '300',
    color: R.colors.black,
  },
  /* -------------------------------------------------------------------------- */
  /*                             Chi tiết chứng chỉ                             */
  /* -------------------------------------------------------------------------- */
  container_detail: {
    backgroundColor: R.colors.white,
    paddingBottom: 10,
  },
  imageDetail: {
    maxWidth: '100%',
    maxHeight: 200,
    resizeMode: 'contain',
  },
  image_container: {
    maxWidth: 340,
    maxHeight: 200,
    alignSelf: 'center',
  },
  status: {
    backgroundColor: R.colors.yellow,
    borderTopLeftRadius: 15,
    borderTopRightRadius: 15,
    paddingLeft: 13,
    paddingVertical: 5,
  },
  container_card_detail: {
    marginVertical: 15,
    borderRadius: 15,
    marginHorizontal: 15,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.5,
    shadowRadius: 1,
    elevation: 1,
  },
  card_item: {
    backgroundColor: R.colors.white,
    borderBottomLeftRadius: 15,
    borderBottomRightRadius: 15,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  header_card_item: {
    justifyContent: 'space-between',
    flexDirection: 'row',
  },
  text_title: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize14,
    fontWeight: '400',
    color: R.colors.black,
  },
  sub_text: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '300',
    lineHeight: 24,
    color: R.colors.black,
  },
});

export default styles;
