import React from 'react';
import {
  Text,
  View,
  Image,
  ScrollView,
} from 'react-native';
import R from '../../../assets/R';
import Header from '../../../components/Header/Header';
import styles from '../style';

const DetailCertificateView = props => {
  return (
    <View style={{flex: 1}}>
      <Header isBack={true} title={'Chứng chỉ toeic'} />
      <ScrollView
        showsVerticalScrollIndicator={false}
        style={styles.container_detail}>
        <View style={styles.container_card_detail}>
          <View style={styles.status}>
            <Text style={[styles.text_title, {color: R.colors.white}]}>
              Chứng chỉ đang được đánh giá
            </Text>
          </View>
          <View style={styles.card_item}>
            <View style={styles.header_card_item}>
              <Text style={styles.text_title}>Chứng chỉ toeic</Text>
            </View>
            <View style={styles.image_container}>
              <Image source={R.images.igProfileDemo} style={styles.imageDetail} />
            </View>
            <View>
              <Text style={styles.sub_text}>Loại chứng chỉ: TOEIC</Text>
              <Text style={styles.sub_text}>Ngày sinh: 23/10/2004</Text>
              <Text style={styles.sub_text}>
                CCCD/CMND đăng ký: 00228956325
              </Text>
              <Text style={styles.sub_text}>Ngày thi: 23/10/2024</Text>
              <Text style={styles.sub_text}>Tổng điểm: 875</Text>
              <View
                style={{
                  flexDirection: 'row',
                  justifyContent: 'space-between',
                }}>
                <Text style={styles.sub_text}>Điểm nói: 0</Text>
                <Text style={styles.sub_text}>Điểm nghe: 445</Text>
              </View>
              <View
                style={{
                  flexDirection: 'row',
                  justifyContent: 'space-between',
                }}>
                <Text style={styles.sub_text}>Điểm đọc: 430</Text>
                <Text style={styles.sub_text}>Điểm viết: 0</Text>
              </View>
              <Text style={styles.sub_text}>Số TRF: 085692265852</Text>
              <Text style={styles.sub_text}>Có hiệu lực đến: 23/10/2026</Text>
              <Text style={[styles.sub_text, {color: R.colors.main}]}>
                Không dùng để đăng ký học bổng
              </Text>
            </View>
          </View>
        </View>
      </ScrollView>
    </View>
  );
};

export default DetailCertificateView;
