import React from 'react';
import {
  SafeAreaView,
  StyleSheet,
  Text,
  TouchableOpacity,
  View,
  StatusBar,
} from 'react-native';
import R from '../../assets/R';
import {
  HEIGHT,
  getFontSize,
  WIDTH,
} from '../../config/Functions';
import {useNavigation} from '@react-navigation/native';

const Header = props => {
  const {title, isBack, isSearch} = props;
  const navigation = useNavigation();
  const IconBack = R.images.icBack;
  const IconSearch = R.images.icSearch;

  return (
    <SafeAreaView style={styles.safeArea}>
      <StatusBar translucent={false} barStyle="light-content" backgroundColor={R.colors.blue500} />

      <View style={styles.headerContainer}>
        {isSearch && (
          <TouchableOpacity
            style={styles.btnSearch}
            onPress={() => {}}>
            <IconSearch stroke={R.colors.white} strokeWidth={2} width={20} height={20} />
          </TouchableOpacity>
        )}

        <Text numberOfLines={1} style={styles.txtTitle}>
          {title}
        </Text>

        {isBack && (
          <TouchableOpacity
            style={styles.btnBack}
            onPress={() => navigation.goBack()}>
            <IconBack width={20} height={20} />
          </TouchableOpacity>
        )}
      </View>
    </SafeAreaView>
  );
};

export default Header;

const styles = StyleSheet.create({
  safeArea: {
    backgroundColor: R.colors.blue500, 
  },
  headerContainer: {
    height: HEIGHT(40),
    width: '100%',
    flexDirection: 'row',
    alignItems: 'center',
    marginBottom: 2,
    justifyContent: 'center',
    backgroundColor: R.colors.blue500,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 5,
    },
    shadowOpacity: 0.1,
    shadowRadius: 5,
    elevation: 5,
  },
  txtTitle: {
    flex: 1,
    fontSize: getFontSize(16),
    textAlign: 'center',
    fontWeight: 'bold',
    color: R.colors.white,
  },
  btnBack: {
    position: 'absolute',
    left: 5,
    width: WIDTH(45),
    height: HEIGHT(30),
    alignItems: 'center',
    justifyContent: 'center',
  },
  btnSearch: {
    position: 'absolute',
    right: 5,
    width: WIDTH(45),
    height: HEIGHT(30),
    alignItems: 'center',
    justifyContent: 'center',
  },
});
