import React from "react";
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  SafeAreaView,
  ScrollView,
} from "react-native";
import {
  Table,
  TableWrapper,
  Row,
  Cell,
} from 'react-native-reanimated-table';
import Header from "../../components/Header/Header";
import R from "../../assets/R";
import I18n from "../../helper/i18/i18n";
import styles from "./style";
const TrainingPointView = (props) => {
  const { dataTitle, dataListInfo } = props;
  const columnFlex = [1, 2, 2, 2, 2, 1];
  return (
    <View style={styles.container}>
      <Header isBack title={I18n.t("TrainingPoint")} />
      <ScrollView 
        showsVerticalScrollIndicator={false}
      >
        <View style={styles.container}>
          
          <View style={styles.card_container}>
            <Text style={styles.text_title}>Điểm rèn luyện trung bình: 100</Text>
            <Table borderStyle={styles.table}>
              <Row
                data={dataTitle}
                style={styles.head}
                flexArr={columnFlex}
                textStyle={styles.text_header}
              />

              {dataListInfo.map((rowData, rowIndex) => (
                <TableWrapper key={rowIndex} style={styles.row}>
                  {rowData.map((cellData, cellIndex) => (
                    <Cell
                      key={cellIndex}
                      flex={columnFlex[cellIndex]}
                      data={
                        <Text
                          style={[styles.text_content, cellData.style]}
                          numberOfLines={1}
                          ellipsizeMode="tail"
                        >
                          {cellData}
                        </Text>
                      }
                      style={styles.cell}
                    />
                  ))}
                </TableWrapper>
              ))}
            </Table>
          </View>
        </View> 
      </ScrollView>
    </View>
  );
};

export default TrainingPointView;


