import React from 'react';
import {
  View,
  Text,
  ImageBackground,
  TouchableOpacity,
  FlatList,
  ScrollView,
  TouchableWithoutFeedback,
  Keyboard,
  Image,
  StatusBar,
  SafeAreaView,
  LogBox,
} from 'react-native';
import HeaderCus from '../home/header';
import R from '../../assets/R';
import I18n from '../../helper/i18/i18n';
import ItemGrid from './item';
import styles from './style';
import {useNavigation} from '@react-navigation/native';



const HomeView = props => {
  LogBox.ignoreAllLogs();
  const {
    menuDataStudy,
    menuDataIndividual,
    menuDataOnlineSer,
    searchText,
    userProfile,
    onMenuItemPress,
    onSearchChange,
    onNavigationProfile,
  } = props;

  const ArrowRightIcon = R.images.icArrowRight;

  const renderMenuItem = React.useCallback(
    ({item}) => {
      return <ItemGrid item={item} onPress={() => onMenuItemPress(item)} />;
    },
    [onMenuItemPress],
  );

  const renderProfileCard = () => (
    <View style={styles.profile_card}>
      <View style={styles.profile_left}>
        <View style={styles.avatar}>
          {userProfile?.avatar ? (
            <Image
              source={{uri: userProfile.avatar}}
              style={styles.avatar_image}
              resizeMode="cover"
            />
          ) : (
            <View style={styles.avatar_placeholder}>
              <Text style={styles.avatar_text}>
                {userProfile?.name?.charAt(0) || 'U'}
              </Text>
            </View>
          )}
        </View>

        <View style={styles.information}>
          <Text
            style={styles.text_card_info}
            numberOfLines={1}
            ellipsizeMode="tail">
            {userProfile?.name || 'Không có tên'}
          </Text>
          <Text
            style={styles.text_card_info}
            numberOfLines={1}
            ellipsizeMode="tail">
            {userProfile?.phone || 'Không có SĐT'}
          </Text>
        </View>
      </View>

      <TouchableOpacity
        style={styles.profile_btn}
        onPress={() => onNavigationProfile()}>
        <Text style={styles.btn_text}>Hồ sơ cá nhân</Text>
        <ArrowRightIcon
          width={5}
          height={10}
          fill={R.colors.txtMain}
          style={styles.icon}
        />
      </TouchableOpacity>
    </View>
  );

  const renderMenuSection = (title, data) => (
    <View style={styles.menu_container}>
      <Text style={styles.menu_title}>{title}</Text>
      <FlatList
        data={data}
        renderItem={renderMenuItem}
        numColumns={3}
        keyExtractor={item => item.id.toString()}
        scrollEnabled={false}
        columnWrapperStyle={styles.row}
        removeClippedSubviews={true}
        maxToRenderPerBatch={9}
        windowSize={10}
      />
    </View>
  );

  const renderBodyView1 = () => {
    return (
      <>
        <ImageBackground
          source={R.images.igBackgroundSlider}
          style={[styles.background_header]}>
          <HeaderCus
            pathLogo={R.images.igLogo}
            width={75}
            height={36}
            textInput={R.colors.white}
            backgroundInput={R.colors.backgroundInputSearch}
            textLabel={I18n.t('Search')}
            textColorLabel={R.colors.white}
            value={searchText}
            onChangeText={onSearchChange}
          />

          {renderProfileCard()}
        </ImageBackground>
      </>
    );
  };

  const renderBody = () => {
    return (
      <TouchableWithoutFeedback onPress={Keyboard.dismiss} accessible={false}>
        <View style={[{flex: 1}]}>
          <View style={styles.container_body}>
            {renderBodyView1()}

            <ScrollView
              showsVerticalScrollIndicator={false}
              style={styles.scroll}
              bounces={false}
              overScrollMode="never">
              {renderMenuSection('Học tập', menuDataStudy)}
              {renderMenuSection('Cá nhân', menuDataIndividual)}
              {renderMenuSection('Dịch vụ trực tuyến', menuDataOnlineSer)}
            </ScrollView>
          </View>
        </View>
      </TouchableWithoutFeedback>
    );
  };

  return (
    <SafeAreaView style={styles.container_body}>
      <StatusBar barStyle="light-content" translucent={false} />
      {renderBody()}
    </SafeAreaView>
  );
};

export default HomeView;
