import {
  Image,
  SafeAreaView,
  StatusBar,
  StyleSheet,
  TextInput,
  View,
} from 'react-native';
import React from 'react';
import R from '../../assets/R';
import styles from './style';
const customHeader = props => {
  const {
    pathLogo,
    width,
    height,
    value,
    textLabel,
    onChangeText,
    textColorLabel,
  } = props;
  const SearchIcon = R.images.icSearch;
  return (
    <View style={[styles.container_header, styles.spacing_header]}>
      <Image source={pathLogo} style={{width: width, height: height}} />
      <View style={styles.size_box}></View>
      <View style={styles.search_box}>
        <SearchIcon
          width={20}
          height={20}
          stroke={R.colors.white}
          stroke-width={2}
        />
        <View style = {{flex: 1}}>
        <TextInput
          value={value}
          onChangeText={onChangeText}
          placeholder={textLabel}
          placeholderTextColor={textColorLabel}
          style={styles.input}
        />
        </View>
       
      </View>
    </View>
  );
};

export default customHeader;
