import React, {Fragment, useRef, useEffect, useState} from 'react';
import {NavigationContainer} from '@react-navigation/native';
import {createStackNavigator} from '@react-navigation/stack';
import TabNavigator from './TabNavigation';
import Home from '../screens/home';
import Elearning from '../screens/elearning';
import QrCode from '../screens/qrcode'
import Notification from '../screens/notification'
import Profile from '../screens/profile'
import NewDetails from '../screens/news_details';
import RollCall from '../screens/roll_call';
import TrainingProgram from '../screens/training_program';
import CertificateRegistration from '../screens/certificate_registration';
import ListCertificate from '../screens/certificate_registration/list';
import DetailCertificate from '../screens/certificate_registration/detail';
import DetailRollCall from '../screens/roll_call/detail';
import TrainingPoint from '../screens/training_point'
import Medical from '../screens/medical';
import DrawerNav from './Drawer/index'
import OutpatientInfomation from '../screens/outpatient_information';
import * as ScreenName from './ScreenNames';
import Debt from '../screens/debt';
import DetailClassSchedule from '../screens/class_schedule/detail';
import ExamSchedule from '../screens/exam_schedule';
const Stack = createStackNavigator();

function MyStack(props) {
  return (
    <Stack.Navigator
      screenOptions={{
        headerStatusBarHeight: 0,
      }}
      headerMode={'none'}
      initialRouteName={ScreenName.TABNAVIGATOR}>
        <Stack.Screen name = {ScreenName.HOMESCREEN} component = {Home}/>
        <Stack.Screen name={ScreenName.TABNAVIGATOR} component={TabNavigator} />
        <Stack.Screen name={ScreenName.DRAWERNAVIGATION} component={DrawerNav} />
        <Stack.Screen name={ScreenName.ELEARNINGSCREEN} component={Elearning}/>
        <Stack.Screen name={ScreenName.QRCODESCREEN} component={QrCode}/>
        <Stack.Screen name={ScreenName.NOTIFICATIONSCREEN} component={Notification}/>
        <Stack.Screen name={ScreenName.PROFILESCREEN} component={Profile}/>
        <Stack.Screen name={ScreenName.NEWSDETAILS} component={NewDetails}/>
        <Stack.Screen name={ScreenName.ROLLCALL} component={RollCall}/>
        <Stack.Screen name={ScreenName.TRAININGPROGRAM} component={TrainingProgram}/>
        <Stack.Screen name={ScreenName.DEBT} component={Debt}/>
        <Stack.Screen name={ScreenName.CERTIFICATEREGISTRATION} component={CertificateRegistration}/>
        <Stack.Screen name={ScreenName.LISTCERTIFICATE} component={ListCertificate}/>
        <Stack.Screen name={ScreenName.DETAILCERTIFICATE} component={DetailCertificate}/>
        <Stack.Screen name={ScreenName.DETAILROLLCALL} component={DetailRollCall}/>
        <Stack.Screen name={ScreenName.TRAININGPOINT} component={TrainingPoint}/>
        <Stack.Screen name={ScreenName.PROFILE} component={Profile}/>
        <Stack.Screen name={ScreenName.MEDICAL} component={Medical}/>
        <Stack.Screen name={ScreenName.OUTPATIENTINFOMATION} component={OutpatientInfomation}/>
        <Stack.Screen name={ScreenName.DETAILCLASSSCHEDULE} component={DetailClassSchedule}/>
        <Stack.Screen name={ScreenName.EXAMSCHEDULE} component={ExamSchedule}/>
    </Stack.Navigator>
  );
}
 
export default function App(props) {
  return (
    <Fragment>
      <NavigationContainer independent={true}>
        <MyStack />
      </NavigationContainer>
    </Fragment>
  );
}
