import React from "react";
import {
  View,
  FlatList,
  SafeAreaView,
  StyleSheet,
} from "react-native";
import ItemList from "./item";
import Header from "../../components/Header/Header";
import I18n from "../../helper/i18/i18n";
import R from "../../assets/R";
import ItemCalendar from "./item_calendar";
const RollCallView = (props) => {
  const { dataRollCall } = props;
  const renderCardItem = ({ item }) => {
    return <ItemList item={item} />;
  };
  return (
    <View style={styles.container}>
      <Header isBack title={I18n.t("RollCall")} />
      <View style={styles.container}>

        <ItemCalendar />
        <View style={styles.flatlist}>
          <FlatList
            data={dataRollCall}
            renderItem={renderCardItem}
            keyExtractor={(item) => item.id.toString()}
            scrollEnabled={true}
            showsVerticalScrollIndicator={false}
          />
        </View>

      </View>
    </View>
  );
};

export default RollCallView;
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  flatlist: {
    flex: 1,
    backgroundColor:R.colors.white,
  },
});
