import React, { useState } from "react";
import {
  Modal,
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  ScrollView,
  Alert,
} from "react-native";
import R from "../../assets/R";
import Checkbox from "../../components/CheckBox";
import Button from "../../components/Button";
import DropdownSelect from "../../components/Dropdown/DropdownSel";
import CustomTextInput from "../../components/Input/TextFieldCus";

const RegistrationModal = ({ visible, onClose, onNavigateToOther }) => {
  const [selectedAccommodationType, setSelectedAccommodationType] =
    useState("other");

  const handleAccommodationTypeChange = (type) => {
    setSelectedAccommodationType(type);
  };

  return (
    <Modal
      visible={visible}
      animationType="slide"
      transparent={true}
      onRequestClose={onClose}
    >
      <View style={styles.container_modal_overlay}>
        <View style={styles.container_card}>
          <View style={styles.header}>
            <Text style={styles.text_header}>Đăng kí thông tin ngoại trú</Text>
          </View>

          <View style={{ flexDirection: "row", marginTop: 15 }}>
            <View style={{ flex: 0.3 }}>
              <Checkbox
                label={"Khác"}
                labelStyle={styles.text_checkbox}
                size={12}
                borderRadius={50}
                borderWidth={1}
                borderColor={R.colors.black}
                isCheck={selectedAccommodationType === "other"}
                onPress={() => handleAccommodationTypeChange("other")}
              />
            </View>
            <View style={{ flex: 1 }}>
              <Checkbox
                label={"Kí túc xá DHQG-HCM"}
                labelStyle={styles.text_checkbox}
                size={12}
                borderRadius={50}
                borderWidth={1}
                onPress={() => handleAccommodationTypeChange("dormitory")}
                isCheck={selectedAccommodationType === "dormitory"}
                borderColor={R.colors.black}
              />
            </View>
          </View>

          {selectedAccommodationType === "other" && (
            <>
              <View style={styles.container_row}>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    placeholder={"Họ và tên"}
                    title={"Tên chủ hộ"}
                    required={true}
                  />

                </View>
                <View style={{ width: '3%' }} ></View>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    title={"Số nhà"}
                    required={true}

                  />
                </View>
              </View>

              <View style={styles.container_row}>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    placeholder={"Xã"}
                    title={"Xã"}
                    required={true}
                  />
                </View>
                <View style={{ width: '3%' }} ></View>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    placeholder={"Tỉnh thành phố"}
                    title={"Tỉnh thành phố"}
                    required={true}
                  />
                </View>
              </View>

              <View style={styles.container_row}>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    title={"Quan hệ với chủ hộ"}
                    required={true}
                  />

                </View>
                <View style={{ width: '3%' }} ></View>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    title={"TG bắt đầu cư trú"}
                    required={true}

                  />


                </View>
              </View>
              <View style={{ maxWidth: '90%', marginBottom: 10 }}>
                <CustomTextInput
                  title={"Địa chỉ chi tiết"}
                  required={true}

                />
              </View>

            </>
          )}

          {selectedAccommodationType === "dormitory" && (
            <View>
              <View style={styles.container_row}>
                <View style={{ flex: 1 }}>
                  <DropdownSelect
                    title={"Vị trí *"}
                    placeholder=""
                    placeholderFontFamily={R.fonts.InterRegular}
                    placeholderFontSize={R.fontsize.fontsSize12}
                    placeholderFontWeight={"400"}
                    placeholderColor={R.colors.grey_800}
                    borderRadius={10}
                    height={40}
                    iconColor={R.colors.black}
                    iconSize={10}
                    marginHorizontal={0}
                    marginVertical={0}
                    titleFontWeight={"400"}
                    fontSize={R.fontsize.fontsSize12}
                    titleFontSize={R.fontsize.fontsSize12}
                    titleFontFamily={R.fonts.InterRegular}
                  />
                </View>
                <View style={{ width: '3%' }} ></View>
                <View style={{ flex: 1 }}>
                  <DropdownSelect
                    title={"Tòa nhà *"}
                    placeholder=""
                    placeholderFontFamily={R.fonts.InterRegular}
                    placeholderFontSize={R.fontsize.fontsSize12}
                    placeholderFontWeight={"400"}
                    placeholderColor={R.colors.grey_800}
                    borderRadius={10}
                    height={40}
                    iconColor={R.colors.black}
                    iconSize={10}
                    marginHorizontal={0}
                    marginVertical={0}
                    titleFontWeight={"400"}
                    fontSize={R.fontsize.fontsSize12}
                    titleFontSize={R.fontsize.fontsSize12}
                    titleFontFamily={R.fonts.InterRegular}
                  />
                </View>
              </View>

              <View style={styles.container_row}>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    title={"Số phòng"}
                    required={true}

                  />
                </View>
                <View style={{ width: '3%' }}></View>
                <View style={{ flex: 1 }}>
                  <CustomTextInput
                    title={"TG bắt đầu cư trú"}
                    required={true}

                  />
                </View>
              </View>
              <CustomTextInput
                title={"Địa chỉ chi tiết"}
                required={true}

              />
            </View>
          )}

          <View style={{ flexDirection: "row", alignSelf: "flex-end" , marginVertical:5}}>
            <View>
              <Button
                backgroundColor={R.colors.white}
                borderWidth={1}
                borderRadius={10}
                borderColor={R.colors.blue500}
                textColor={R.colors.blue500}
                fontWeight={'400'}
                fontFamily={R.fonts.InterRegular}
                title={"Huỷ"}
                marginHorizontal={0}
                marginVertical={0}
                width={51}
                height={31}
                fontSize={R.fontsize.fontsSize12}
                onPress={onClose}
              />
            </View>
            <View style={{ width: '3%' }}></View>
            <View>
              <Button
                backgroundColor={R.colors.blue500}
                borderWidth={1}
                borderRadius={10}
                borderColor={R.colors.blue500}
                textColor={R.colors.white}
                fontWeight={'400'}
                fontFamily={R.fonts.InterRegular}
                title={"Đăng kí mới"}
                marginHorizontal={0}
                marginVertical={0}
                width={100}
                height={31}
                fontSize={R.fontsize.fontsSize12}
                onPress={() => {
                  if (selectedAccommodationType === "other") {
                    console.log("Đăng ký ngoại trú");
                  } else {
                    console.log("Chuyển đến đăng ký kí túc xá");
                  }
                }}
              />
            </View>
          </View>
        </View>
      </View>
    </Modal>
  );
};

export default RegistrationModal;

const styles = StyleSheet.create({
  container_modal_overlay: {
    flex: 1,
    backgroundColor: R.colors.black_500,
    justifyContent: "center",
    alignItems: "center",
  },
  container_card: {
    minWidth: "90%",
    maxHeight: "80%",
    backgroundColor: R.colors.white,
    borderRadius: 10,
    elevation: 10,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  header: {
    alignItems: "center",
  },
  text_header: {
    color: R.colors.blue500,
    fontFamily: R.fonts.InterMedium,
    fontWeight: "500",
    fontSize: R.fontsize.fontsSize18,
  },
  text_checkbox: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
  },
  container_row: {
    flexDirection: "row",
  },
  text_dormitory_info: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
    textAlign: "center",
    lineHeight: 20,
  },

});
