import {StyleSheet, Dimensions} from 'react-native';
import R from '../../assets/R';
const {width, height} = Dimensions.get('window');

const styles = StyleSheet.create({
  /* -------------------------------------------------------------------------- */
  /*                                    Body                                    */
  /* -------------------------------------------------------------------------- */
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  input: {
    height: 40,
    paddingHorizontal: 10,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    color: R.colors.gray400,
    fontSize: R.fontsize.fontsSize12,
  },
  tab_container: {
    marginHorizontal: 10,
    justifyContent: 'center',
  },
  tab_button: {
    marginHorizontal: 5,
    borderRadius: 15,
    width: 132,
    backgroundColor: R.colors.gray400,
    alignItems: 'center',
    justifyContent: 'center',
  },
  tabButtonActive: {
    backgroundColor: R.colors.blue500,
  },
  tabButtonText: {
    fontFamily: R.fonts.InterSemiBold,
    fontWeight: '600',
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.white,
  },
  tabButtonTextActive: {
    color: R.colors.white,
    fontWeight: '600',
    fontFamily: R.fonts.InterSemiBold,
    fontSize: R.fontsize.fontsSize12,
  },
  tab_scroll_content: {
    height: 28,
    marginTop: 5,
  },
  sub_text: {
    color: R.colors.black,
    marginLeft: 15,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '300',
    fontSize: R.fontsize.fontsSize12,
  },
  /* -------------------------------------------------------------------------- */
  /*                                    Item                                    */
  /* -------------------------------------------------------------------------- */
  container_item: {
    backgroundColor: R.colors.backgroundCard,
    marginHorizontal: 15,
    marginVertical: 5,
    borderRadius: 10,
    paddingVertical: 9,
    paddingHorizontal: 15,
  },
  title: {
    color: R.colors.black,
    fontSize: R.fontsize.fontsSize14,
    fontFamily: R.fonts.InterMedium,
    fontWeight: '500',
    lineHeight: 24,
  },
  sub_title: {
    color: R.colors.black,
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '300',
    lineHeight: 24,
    fontFamily: R.fonts.InterRegular,
  },
  price_text: {
    color: R.colors.blue500,
    fontFamily: R.fonts.InterRegular,
    fontWeight: 'bold',
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  code: {
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: 'bold',
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  type_of_debt: {
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: 'bold',
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  note: {
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  time: {
    color: R.colors.red,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  container_content: {
    flexDirection: 'row',
  },
  container_button: {},
  text_button: {
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    fontSize: R.fontsize.fontsSize12,
  },
});

export default styles;
