import {StyleSheet} from 'react-native';
import R from '../../assets/R';
import {CELL_WIDTH, CELL_HEIGHT, BOTTOM_SHEET_HEIGHT} from '../../config/Functions';

const styles = StyleSheet.create({
  // ===== CONTAINER CHÍNH =====
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    width: '100%',
    alignItems: 'center',
  },

  // ===== HEADER SECTION (renderHeader) =====
  header: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    paddingVertical: 15,
    marginHorizontal: 15,
  },
  header_title: {
    fontSize: R.fontsize.fontsSize16,
    fontFamily: R.fonts.InterMedium,
    color: R.colors.black,
    fontWeight: '600',
  },
  navButton: {
    width: 30,
    height: 30,
    borderRadius: 50,
    backgroundColor: R.colors.blue500,
    alignItems: 'center',
    justifyContent: 'center',
  },
  navButtonText: {
    color: R.colors.white,
    fontSize: R.fontsize.fontsSize20,
    fontFamily: R.fonts.InterMedium,
  },

  // ===== WEEK DAYS SECTION (renderWeekDays) =====
  weekDaysContainer: {
    flexDirection: 'row',
    alignSelf: 'center',
    paddingBottom: 3,
    marginBottom: 5,
  },
  weekDayCell: {
    width: CELL_WIDTH,
    alignItems: 'center',
  },
  weekDayText: {
    fontFamily: R.fonts.fontMedium,
    fontSize: R.fontsize.fontSizeLabel,
    fontWeight: '600',
    color: R.colors.black,
  },

  // ===== CALENDAR GRID SECTION (renderCalendarGrid, renderDayCell) =====
  calendarGrid: {
    alignSelf: 'center',
  },
  weekRow: {
    flexDirection: 'row',
  },
  
  // Day Cell Styles
  dayCell: {
    width: CELL_WIDTH,
    minHeight: CELL_HEIGHT,
    borderWidth: 1,
    borderColor: R.colors.gray220,
    padding: 6,
    alignItems: 'center',
  },
  dayCellInactive: {
    backgroundColor: R.colors.gray100, // Background cho ngày không thuộc cùng tháng
  },
  selectedDayCell: {
    borderColor: R.colors.blue500,
    borderWidth: 1,
  },
  todayCell: {
    // Thêm style cho ô ngày hôm nay nếu cần
  },
  
  // Day Text Styles
  dayText: {
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '400',
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
    marginBottom: 2,
  },
  dayTextInactive: {
    color: R.colors.gray200, // Màu text mờ hơn cho ngày khác tháng
    opacity: 0.6,
  },
  selectedDayText: {
    color: R.colors.black,
    fontWeight: '500',
    fontFamily: R.fonts.InterSemiBold,
  },
  todayText: {
    color: R.colors.white,
    fontWeight: '500',
    fontFamily: R.fonts.InterSemiBold,
    backgroundColor: R.colors.blue500,
    borderRadius: 15,
    paddingHorizontal: 6,
    paddingVertical: 4,
  },

  // Event Styles in Day Cell
  eventsContainer: {
    width: '100%',
    flex: 1,
  },
  eventBar: {
    paddingVertical: 2,
    paddingHorizontal: 5,
    borderRadius: 10,
    marginBottom: 2,
    backgroundColor: R.colors.blue500,
  },
  eventBarText: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.white,
    fontWeight: '400',
    fontFamily: R.fonts.InterRegular,
  },
  moreEventsText: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.gray200,
    fontWeight: '400',
    fontFamily: R.fonts.InterRegular,
    textAlign: 'center',
  },

  // ===== MODAL BOTTOM SHEET SECTION (ModalBottomSheetView) =====
  modalBackdrop: {
    flex: 1,
    backgroundColor: R.colors.gray220,
    justifyContent: 'flex-end',
  },
  bottomSheet: {
    height: BOTTOM_SHEET_HEIGHT,
    backgroundColor: R.colors.white,
    borderTopLeftRadius: 20,
    borderTopRightRadius: 20,
  },
  bottomSheetContent: {
    height: BOTTOM_SHEET_HEIGHT,
  },
  
  // Bottom Sheet Header
  dragHandle: {
    width: 40,
    height: 4,
    backgroundColor: R.colors.gray150,
    borderRadius: 5,
    alignSelf: 'center',
    marginTop: 10,
    marginBottom: 15,
  },
  bottomSheetHeader: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 15,
  },
  bottomSheetTitle: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterMedium,
    color: R.colors.black,
    fontWeight: '600',
    flex: 1,
  },
  closeButton: {
    width: 30,
    height: 30,
    borderRadius: 15,
    backgroundColor: R.colors.gray200,
    alignItems: 'center',
    justifyContent: 'center',
  },
  closeButtonText: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
  },

  // Bottom Sheet Events List
  eventsScrollView: {
    paddingTop: 10,
  },
  containerBottomSheet: {
    flex: 1,
    marginBottom: 10,
  },
  noEventsContainer: {
    flex: 1,
    alignItems: 'center',
    justifyContent: 'center',
    paddingVertical: 40,
  },
  noEventsText: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.gray200,
    fontWeight: '400',
  },

  // Event Card Styles
  eventCard: {
    flexDirection: 'row',
    backgroundColor: R.colors.white,
    borderRadius: 12,
    padding: 15,
    marginBottom: 10,
    marginHorizontal: 15,
    borderLeftWidth: 4,
    borderLeftColor: R.colors.blue500,
    shadowColor: R.colors.black250,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 1,
    shadowRadius: 1,
    elevation: 2,
  },
  eventTimeContainer: {
    minWidth: 80,
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    marginRight: 15,
  },
  eventTime: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterMedium,
    color: R.colors.blue500,
    fontWeight: '600',
  },
  eventContent: {
    flex: 1,
  },
  eventTitle: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.black,
    fontWeight: '600',
    marginBottom: 4,
  },
  eventDescription: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    color: R.colors.gray200,
    fontWeight: '400',
  },
});

export {styles, CELL_WIDTH, BOTTOM_SHEET_HEIGHT};
