import React, { useState ,useMemo} from 'react';
import {Text, View, StyleSheet} from 'react-native';
import CertificateRegistrationView from './view';
import {launchCamera, launchImageLibrary} from 'react-native-image-picker';
const CertificateRegistration = (props) => {
  const [titleHeader,setTitleHeader]= useState('CertificateRegisitor')
  const [isSelected, setSelection] = useState(false);
  const [selectedValue, setSelectedValue] = useState(null); 
  const [image, setImage] = useState(null);
  const [dataListCertificate, setdataListCertificate]= useState([
    {
    id: 1,
    user_info: {
      full_name: 'Nguyễn Văn A',
      date: '27/11/2004',
      identity_card: '0129210102',
    },
    certificates: [
      {
        id_certificate: 'cer_1',
        type_certificate: 'TOEIC',
        status: 'Chờ duyệt',
        registered_date: '2025-07-01',
        listening_point: '9',
        speaking_point:'9',
        reading_point:'9',
        writing_score:'9',
        total_score:'9',
        date_exam:'27/02/2021',
        date_effective:'28/09/2023',
        code_certificate :'192381832183',
        image_certificate:'https://sf-static.upanhlaylink.com/img/image_202507281a9a3a8e0a76ab471f9415ee21d9c57e.jpg'
      },
      
    ],
    apply_for_ascholarship: false
  },
   {
    id: 2,
    user_info: {
      full_name: 'Nguyễn Văn A',
      date: '27/11/2004',
      identity_card: '0129210102',
    },
    certificates: [
      {
        id_certificate: 'cer_1',
        type_certificate: 'TOEIC',
        status: 'Chờ duyệt',
        registered_date: '2025-07-01',
        listening_point: '9',
        speaking_point:'9',
        reading_point:'9',
        writing_score:'9',
        total_score:'9',
        date_exam:'27/02/2021',
        date_effective:'28/09/2023',
        code_certificate :'192381832183',
        image_certificate:'https://sf-static.upanhlaylink.com/img/image_202507281a9a3a8e0a76ab471f9415ee21d9c57e.jpg'
      },
      
    ],
    apply_for_ascholarship: false
  },
  ])
  const dropdownData = useMemo(() => {
    return dataListCertificate.flatMap(user => 
      user.certificates.map(certificate => ({
        label: `${user.user_info.full_name} - ${certificate.status}`,
        value: user.id,
        originalCertificate: certificate, 
        originalUser: user.user_info
      }))
    );
  }, [dataListCertificate]);

  const handleSelect = (item) => {
    console.log("Đã chọn:", item);
    setSelectedValue(item.value); 

  };
  
  const openImagePicker = () => {
    const options = {
      mediaType: 'photo',
      quality: 1,
    };

    launchImageLibrary (options,(res)=>{
      if (res.didCancel) {
        console.log('User cancelled image picker');
      } else if (res.errorCode) {
        console.log('ImagePicker Error: ', res.errorCode);
      } else {
        // Lấy URI từ asset đầu tiên
        const imageUri = res.assets && res.assets[0] ? res.assets[0].uri : null;
        
        // Lưu URI vào state
        setImage(imageUri);
      }
    })
  };
  
  return (
    <CertificateRegistrationView 
      titleHeader={titleHeader}
      dataList={dropdownData}
      value={selectedValue}
      onSelect={handleSelect}
      isSelected={isSelected}
      setSelection={setSelection}
      image={image}
      openImagePicker={openImagePicker}
    />
  );
};

export default CertificateRegistration;
