import React, {useRef} from 'react';
import {View, Text, TextInput, StyleSheet, Platform} from 'react-native';
import R from '../../assets/R';
import {HEIGHT} from '../../config/Functions';

const CustomTextInput = ({
  title,
  required,
  placeholder,
  value,
  onChangeText,
  backgroundColor,
  editable,
  height,
  width,
  containerMarginVertical,
  containerMarginHorizontal,
  containerMarginBottom,
  containerMarginTop,
  containerBackgroundColor,
  messageError,
  color,
  icon,
  secureTextEntry,
  fontSize,
  onFocus,
  ...restProps
}) => {
  const inputRef = useRef(null);

  const renderMess = () => {
    if (value && value.trim().length > 0) return `${title} không hợp lệ`;
    return `Vui lòng nhập ${title ? title.toLowerCase() : messageError}`;
  };

  return (
    <View
      style={{
        width: width,
        marginVertical: containerMarginVertical,
        marginHorizontal: containerMarginHorizontal,
        marginBottom: containerMarginBottom,
        backgroundColor: containerBackgroundColor,
        marginTop: containerMarginTop,
      }}>
      {/* FUNCTIONALITY: Title với sao đỏ nếu required */}
      {title && (
        <View style={styles.titleContainer}>
          <Text style={styles.title}>
            {title}
            {required && <Text style={styles.required}> *</Text>}
          </Text>
        </View>
      )}

      {/* FUNCTIONALITY: Input container với background tùy chỉnh */}
      <View
        style={[
          styles.inputContainer,
          backgroundColor && {backgroundColor}, // NOTE: Chỉ apply backgroundColor khi có truyền vào
        ]}>
        <TextInput
          ref={inputRef}
          style={{
            height: HEIGHT(35),
            color: color,
            borderColor: R.colors.grayBorderInputTextHeader,
            fontSize: fontSize,
            paddingVertical: 5,
            backgroundColor:
              editable === false
                ? backgroundColor || R.colors.blue1 // khi disabled thì lấy màu xám
                : backgroundColor, // khi enable thì lấy màu bạn truyền,
          }}
          placeholder={placeholder}
          placeholderTextColor={R.colors.grey_100}
          value={value}
          onChangeText={onChangeText}
          editable={editable}
          onFocus={onFocus}
          autoCapitalize="none"
          {...restProps}
        />
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  // FUNCTIONALITY: Container wrapper
  container: {
    marginVertical: 5,
    backgroundColor: R.colors.red,
  },

  // UI/UX: Container cho title
  titleContainer: {
    flexDirection: 'row',
    marginBottom: 3,
  },

  // UI/UX: Title text
  title: {
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterMedium,
    fontWeight: '800',
    color: R.colors.black,
  },

  // UI/UX: Dấu sao đỏ bắt buộc
  required: {
    color: R.colors.red,
    fontSize: R.fontsize.fontsSize12,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '500',
  },

  // UI/UX: Input container - KHÔNG có backgroundColor mặc định
  inputContainer: {
    // NOTE: Không set backgroundColor ở đây
    borderRadius: 10,
    borderWidth: 1,
    borderColor: R.colors.grey_200,
    paddingHorizontal: 10,
    height: 35,
    backgroundColor: R.colors.white,
  },

  // UI/UX: Input text styles
  input: {
    fontSize: R.fontsize.fontsSize10,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    color: R.colors.black, // FIXME: Đổi từ grey_200 sang black để text rõ hơn
  },
});

export default CustomTextInput;
