import { StyleSheet } from "react-native";
import R from "../../assets/R";
const styles = StyleSheet.create({
    container: {
      flex: 1,
      backgroundColor:R.colors.white,
    },
    card_container: {
      backgroundColor: R.colors.white,
      marginHorizontal: 15,
      marginVertical: 10,
      shadowColor: R.colors.black,
      shadowOffset: {
        width: 0,
        height: 2,
      },
      shadowOpacity: 0.5,
      shadowRadius: 1,
      elevation: 1,
      paddingVertical: 10,
      paddingHorizontal: 15,
      borderRadius: 10,
    },
    table: {
      borderWidth: 1,
      borderColor: R.colors.grey_200,
    },
    head: {
      backgroundColor: R.colors.grey_200,
      minHeight: 44,
    },
    row: {
      flexDirection: 'row',
      backgroundColor: R.colors.white,
    },
    cell: {
      justifyContent: 'center',
      alignItems: 'center',
      paddingVertical: 10
    },
    text_header: {
      fontFamily: R.fonts.InterRegular,
      fontSize: R.fontsize.fontsSize12,
      fontWeight: '400',
      color: R.colors.black,
      textAlign: 'center',
    },
    text_content: {
      fontFamily: R.fonts.InterRegular,
      fontSize: R.fontsize.fontsSize12,
      fontWeight: '400',
      color: R.colors.black,
      textAlign: 'center',
    },
    text_title: {
      fontFamily: R.fonts.InterSemiBold,
      fontSize: R.fontsize.fontsSize14,
      fontWeight: '500',
      color: R.colors.blue500,
      marginBottom: 10
    }
  });
export default styles;