import { StyleSheet } from "react-native";
import R from "../../assets/R";

const styles = StyleSheet.create({
    container_body: {
      flex: 1,
      backgroundColor: R.colors.white,
    },
    background_header: {
      height: 295,
      position: 'relative',
    },
    profile_card: {
      position: 'absolute',
      bottom: -30,
      flexDirection: "row",
      alignItems: "center",
      backgroundColor: R.colors.white,
      paddingVertical: 10,
      paddingHorizontal: 15,
      marginHorizontal: 15,
      borderRadius: 15,
      shadowColor: R.colors.black,
      shadowOffset: { width: 0, height: 2 },
      shadowOpacity: 0.22,
      shadowRadius: 2.22,
      elevation: 3,
    },
    profile_left: {
      flexDirection: "row",
      alignItems: "center",
      flex: 3,
    },
  
    avatar: {
      width: 37,
      height: 37,
      borderRadius: 20,
      backgroundColor: R.colors.white,
      overflow: 'hidden',
    },
    avatar_image: {
      width: '100%',
      height: '100%',
    },
    avatar_placeholder: {
      width: '100%',
      height: '100%',
      justifyContent: 'center',
      alignItems: 'center',
      backgroundColor: R.colors.grey,
    },
    avatar_text: {
      fontSize: R.fontsize.fontsSize16,
      fontWeight: '600',
      color: R.colors.white,
      fontFamily: R.fonts.InterSemiBold,
    },
    information: {
      flex: 2,
      marginLeft: 5,
    },
    text_card_info: {
      fontSize: R.fontsize.fontsSize12,
      fontWeight: "400",
      color: R.colors.black,
      fontFamily: R.fonts.InterRegular,
      numberOfLines: 1,
      ellipsizeMode: "tail",
    },
    profile_btn: {
      paddingVertical: 5,
      paddingHorizontal: 10,
      backgroundColor: R.colors.gray220,
      minHeight: 21,
      maxWidth: 108,
      borderRadius: 15,
      flexDirection: "row",
      justifyContent: 'center',
      alignItems: 'center',
    },
    btn_text: {
      fontSize: R.fontsize.fontsSize10,
      fontWeight: "400",
      color: R.colors.black,
      fontFamily: R.fonts.InterRegular,
      
    },
    icon: {
      marginLeft: 5,
    },
    menu_container: {
      marginHorizontal: 15,
    },
    menu_title: {
      color: R.colors.txtMain,
      fontSize: R.fontsize.fontsSize14,
      fontWeight: "600",
      color: R.colors.black,
      fontFamily: R.fonts.InterMedium,
    },
    scroll: {
      flex: 1,
      marginTop: 35,
    }
  });
  export default styles;