import React from "react";
import { View, Text, StyleSheet, Image, TouchableOpacity } from "react-native";
import R from "../../assets/R";
const ItemGrid = ({ item ,onPress }) => {
   const IconComponent = item.icon;
  return (
    <TouchableOpacity
      onPress={onPress}
      style={styles.menu_item}
    >
      <View style={styles.icon_container}>
        <IconComponent 
          width={35} 
          height={35} 
        />
      </View>
      <Text style={styles.menu_text}>{item.title}</Text>
    </TouchableOpacity>
  );
};

export default ItemGrid;

const styles = StyleSheet.create({
  menu_item: {
    alignItems: "center", 
    paddingVertical: 10,
    paddingHorizontal: 5,
    marginHorizontal: 5,
    marginVertical: 5,
    flex: 1,
    maxWidth: "30%",
    minHeight:"30%"
  },
  icon_container: {
    width: 35,
    height: 35,
    backgroundColor:R.colors.white,
  },
  menu_text: {
    fontSize: R.fontsize.fontsSize12,
    fontWeight: "600",
    color: R.colors.black,
    fontFamily: R.fonts.InterMedium,
    textAlign: "center",
  },
});
