import React, { Component, useState } from "react";
import { View, Text, Linking } from "react-native";
import * as SCREENNAME from '../../routers/ScreenNames'
import Homeview from "./view";
import R from "../../assets/R";
import { useNavigation } from '@react-navigation/native';
const Home = (props) => {
  const navigation = useNavigation();
  const [selectedMenuItem, setSelectedMenuItem] = useState("");
  const [searchText, setSearchText] = useState("");
  const [userProfile, setUserProfile] = useState({
    name: "NGUYỄN MINH ĐỨC",
    phone: "0895457",
    avatar: null,
  });
  const menuDataStudy = [
    { id: 1, title: "Lịch học", icon: R.images.icCalendar, screenName: SCREENNAME.DRAWERNAVIGATION,action: 'NAVIGATE',},
    { id: 2, title: "Lịch thi", icon: R.images.icExamSchedule, screenName: SCREENNAME.EXAMSCHEDULE,action: 'NAVIGATE',params: { type: 'exam' }},
    { id: 3, title: "Điểm danh", icon: R.images.icRollCall , screenName: SCREENNAME.ROLLCALL,action: 'NAVIGATE',},
    { id: 4, title: "Điểm rèn luyện", icon: R.images.icTrainingPoint,screenName: SCREENNAME.TRAININGPOINT,action: 'NAVIGATE', },
  ];
  const menuDataIndividual = [
    {
      id: 5,
      title: "Đăng kí ngoại trú",
      icon: R.images.icOutpatientRegistration,
      screenName: SCREENNAME.OUTPATIENTINFOMATION,
      action: 'NAVIGATE',
    },
    { id: 6, title: "Việc làm", icon: R.images.icJob ,screenName: SCREENNAME.ELEARNINGSCREEN,action: 'NAVIGATE',},
    { id: 7, title: "Y tế", icon: R.images.icMedical,screenName: SCREENNAME.MEDICAL,action: 'NAVIGATE', },
  ];
  const menuDataOnlineSer = [
    { id: 8, title: "Đăng kí chứng chỉ", icon: R.images.icRFCertificate,screenName: SCREENNAME.LISTCERTIFICATE,action: 'NAVIGATE', },
    { id: 9, title: "Công nợ", icon: R.images.icDebt,screenName: SCREENNAME.DEBT,action: 'NAVIGATE', },
    { id: 10, title: "Chương trình đào tạo", icon: R.images.icTrainingProgram ,screenName: SCREENNAME.TRAININGPROGRAM, action: 'NAVIGATE' },
    { id: 11, title: "Tài liệu học tập", icon: R.images.icStudyMaterials, action: 'OPEN_URL', url: 'https://job-portal.com' },
  ];
  const actionHandlers = {
    NAVIGATE: (item) => {
      navigation.navigate(item.screenName, {
        ...item.params,
        itemData: item,
        title: item.title,
      });
    },

    OPEN_URL: (item) => {
      Linking.openURL(item.url).catch((err) => {
        console.error("Failed to open URL:", err);
      });
    },

    SHOW_MODAL: (item) => {
      console.log("Show modal for:", item.title);
    },

    CALL_API: (item) => {
      console.log("Calling API for:", item.title);
    },
  };
  const handleMenuItemPress = (item) => {

    const handler = actionHandlers[item.action];
    if (handler) {
      handler(item);
    } else {
      console.warn(`No handler found for action: ${item.action}`);
    }
  };

  const handleSearchChange = (text) => {
    setSearchText(text);
  };

  return (
    <Homeview
      menuDataStudy={menuDataStudy}
      menuDataIndividual={menuDataIndividual}
      menuDataOnlineSer={menuDataOnlineSer}
      selectedMenuItem={selectedMenuItem}
      searchText={searchText}
      userProfile={userProfile}
      onMenuItemPress={handleMenuItemPress}
      onSearchChange={handleSearchChange}
    />
  );
};

export default Home;
