import { Image, SafeAreaView, StatusBar, StyleSheet, TextInput, View } from "react-native";
import React from "react";
import R from "../../assets/R";
const customHeader = (props) => {
  const {
    pathLogo,
    width,
    height,
    value,
    textLabel,
    onChangeText,
    textColorLabel,
  } = props;
  const SearchIcon = R.images.icSearch;
  return (

    <View style={[styles.container ,{justifyContent: 'center',marginTop:20}]}>
      <Image
        source={pathLogo}
        style={{ width: width, height: height }}
      />
      <View style={styles.size_box}></View>
      <View
        style={styles.search_box}
      >
        <SearchIcon
          width={25}
          height={25}
          stroke={R.colors.white}
          stroke-width={2}
        />
        <View style={styles.size_box_2}></View>

        <TextInput
          value={value}
          onChangeText={onChangeText}
          placeholder={textLabel}
          placeholderTextColor={textColorLabel}
          style={styles.input}
        />
      </View>
    </View>
  );
};

export default customHeader;

const styles = StyleSheet.create({
  container: {
    flexDirection: "row",
    marginHorizontal: 15,
  },
  size_box:{
    width: '20%',
  },
  size_box_2:{
    width: '2.5%',
  },
  search_box: {
    flex: 3,
    flexDirection: "row",
    backgroundColor: R.colors.black250,
    alignItems: "center",
    borderColor: R.colors.gray280,
    borderRadius: 100,
    borderWidth: 1,
    maxHeight:40,
    paddingHorizontal: 14,
    paddingVertical: 5
  },

  input: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.white,
    margin:0,
    padding:0,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
  },
});
