import { StyleSheet, Text, View } from "react-native";
import React from "react";
import { useNavigation } from "@react-navigation/native";
import R from "../../assets/R";
import Button from "../../components/Button";
const ItemList = ({ item , onPayPress}) => {
  const navigate = useNavigation();
  const QrCodeIconButton = R.images.icQrCodeButton;
  const { displayConfig } = item;
  return (
    <View style={styles.container}>
      <Text style={[styles.title, { color: displayConfig.titleColor }]}>
        {item.title_notifi_student_code}
      </Text>
      <View style={styles.container_content}>
        <Text style={styles.sub_title}>Số tiền: </Text>
         <Text style={[styles.price_text, { color: displayConfig.priceColor }]}>
          {item.price}
        </Text>
      </View>
      <View style={styles.container_content}>
        <Text style={styles.sub_title}>Mã công nợ: </Text>
        <Text style={styles.code}>{item.code_debt}</Text>
      </View>
      <View style={styles.container_content}>
        <Text style={styles.sub_title}>Loại công nợ: </Text>
        <Text style={[styles.type_of_debt, { color: displayConfig.typeDebtColor }]}>
          {item.type_debt}
        </Text>
      </View>
      <View style={styles.container_content}>
        <Text style={styles.sub_title}>Ghi chú: </Text>
        <Text style={[{ flex: 1 }, styles.note]}>{item.message_debt}</Text>
      </View>
      <View style={styles.container_content}>
             {displayConfig.showPaymentTerm && (
          <View style={{flex:1, flexDirection:'row'}}>
            <Text style={styles.sub_title}>Hạn thanh toán: </Text>
            <Text style={[styles.time, { color: displayConfig.timeColor }]}>
              {item.payment_term}
            </Text>
          </View>
        )}
        
      {displayConfig.showButton && (
          <View style={styles.container_button}>
            <Button
            marginRight={0}
              title="Thanh toán"
              textStyle={styles.text_button}
              icon={(props) => <QrCodeIconButton width={16} height={16} />}
              backgroundColor={R.colors.buttonColorSel}
              textColor={R.colors.white}
              justifyContent="center"
              alignItems="center"
              height={32}
              borderRadius={8}
              paddingHorizontal={12}
              iconSpacingHorizontal={4}
                onPress={() => onPayPress?.(item)} 
            />
          </View>
        )}
          
      </View>
    </View>
  );
};

export default ItemList;

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.backgroundCard,
    marginHorizontal: 15,
    marginVertical: 5,
    borderRadius: 10,
    paddingVertical: 9,
    paddingHorizontal: 15,
  },
  title: {
    color: R.colors.black,
    fontSize: R.fontsize.fontsSize14,
    fontFamily: R.fonts.InterMedium,
    fontWeight:'500',
    lineHeight: 24,
  },
  sub_title: {
    color: R.colors.black,
    fontSize: R.fontsize.fontsSize12,
    fontWeight: "300",
    lineHeight: 24,
    fontFamily: R.fonts.InterRegular,
  },
  price_text: {
    color: R.colors.blue500,
    fontFamily: R.fonts.InterRegular,
    fontWeight: "bold",
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  code: {
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: "bold",
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  type_of_debt: {
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: "bold",
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  note: {
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  time: {
    color: R.colors.red,
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    lineHeight: 24,
    fontSize: R.fontsize.fontsSize12,
  },
  container_content: {
    flexDirection: "row", 
  },
  container_button:{
  },
  text_button:{
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    fontSize: R.fontsize.fontsSize12,
  },
});
