import {StyleSheet, Dimensions} from 'react-native';
import R from '../../assets/R';

const {width: screenWidth, height: screenHeight} = Dimensions.get('window');
const CELL_WIDTH = (screenWidth - 30) / 7;
const CELL_HEIGHT = (screenHeight - 140) / 6;
const BOTTOM_SHEET_HEIGHT = screenHeight * 0.6;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
    alignItems: 'center',
  },
  header: {
      flexDirection: 'row',
      alignItems: 'center',
      justifyContent: 'space-between',
      paddingVertical: 15,
    },
    header_title: {
      fontSize: R.fontsize.fontsSize16,
      fontFamily: R.fonts.InterMedium,
      color: R.colors.black,
      fontWeight: '600',
    },
    navButton: {
      width: 30,
      height: 30,
      borderRadius: 20,
      backgroundColor: R.colors.blue500,
      alignItems: 'center',
      justifyContent: 'center',
    },
    navButtonText: {
      color: R.colors.white,
      fontSize: R.fontsize.fontsSize16,
      fontFamily: R.fonts.InterMedium,
    },
    weekDaysContainer: {
      flexDirection: 'row',
      paddingBottom: 5,
      marginBottom: 5,
    },
    weekDayCell: {
      width: CELL_WIDTH,
      alignItems: 'center',
    },
    weekDayText: {
      fontFamily: R.fonts.InterRegular,
      fontSize: R.fontsize.fontsSize10,
      fontWeight: '400',
      color: R.colors.black,
    },
    calendarGrid: {
    },
    weekRow: {
      flexDirection: 'row',
    },
    dayCell: {
      width: CELL_WIDTH,
      minHeight: CELL_HEIGHT,
      borderWidth: 1,
      borderColor: R.colors.grey_200,
      padding: 4,
      alignItems: 'center',
    },
    selectedDayCell: {
      borderColor: R.colors.blue500,
      borderWidth: 1,
    },
    dayText: {
      fontSize: R.fontsize.fontsSize12,
      fontWeight: '500',
      fontFamily:R.fonts.InterMedium,
      color: R.colors.black,
      marginBottom: 2,
    },
    dayTextInactive: {
      color: R.colors.grey_100,
      opacity: 1,
    },
    selectedDayText: {
      color: R.colors.black,
      fontWeight: 'bold',
      fontFamily: R.fonts.InterSemiBold,
    },
    todayText: {
      color: R.colors.white,
      fontWeight: 'bold',
      fontFamily: R.fonts.InterSemiBold,
      backgroundColor: R.colors.blue500,
      borderRadius: 10,
      paddingHorizontal: 5,
    },
  
    eventsContainer: {
      width: '100%',
      flex: 1,
    },
    eventBar: {
      paddingVertical: 2,
      paddingHorizontal: 5,
      borderRadius: 5,
      marginBottom: 2,
    },
    eventBarText: {
      fontSize: R.fontsize.fontsSize10,
      color: R.colors.white,
      fontWeight: '500',
      fontFamily: R.fonts.InterRegular
    },
    moreEventsText: {
      fontSize: R.fontsize.fontsSize10,
      color: R.colors.grey_100,
      textAlign: 'center',
    },
  
    modalBackdrop: {
      flex: 1,
      backgroundColor: R.colors.grey_200,
      justifyContent: 'flex-end',
    },
    bottomSheet: {
      height: BOTTOM_SHEET_HEIGHT,
      backgroundColor: R.colors.white,
      borderTopLeftRadius: 20,
      borderTopRightRadius: 20,
     
    },
    bottomSheetContent: {
      paddingHorizontal: 15,
    },
    dragHandle: {
      width: 40,
      height: 4,
      backgroundColor: R.colors.grey_200,
      borderRadius: 2,
      alignSelf: 'center',
      marginTop: 10,
      marginBottom: 15,
    },
    bottomSheetHeader: {
      flexDirection: 'row',
      alignItems: 'center',
      justifyContent: 'space-between',
      marginBottom: 20,
    },
    bottomSheetTitle: {
      fontSize: R.fontsize.fontSizeHeader1,
      fontFamily: R.fonts.InterMedium,
      color: R.colors.black,
      flex: 1,
    },
    closeButton: {
      width: 30,
      height: 30,
      borderRadius: 15,
      backgroundColor: R.colors.grey_200,
      alignItems: 'center',
      justifyContent: 'center',
    },
    closeButtonText: {
      fontSize: R.fontsize.fontsSize12,
      color: R.colors.grey_800,
      fontFamily: R.fonts.InterRegular,
    },
  
    noEventsContainer: {
      flex: 1,
      alignItems: 'center',
      justifyContent: 'center',
      paddingVertical: 40,
    },
    noEventsText: {
      fontSize: R.fontsize.fontsSize12,
      fontFamily: R.fonts.InterRegular,
      color: R.colors.grey_800,
      fontWeight: '400'
    },
    eventCard: {
      flexDirection: 'row',
      backgroundColor: R.colors.white,
      borderRadius: 12,
      padding: 15,
      marginBottom: 12,
      borderLeftWidth: 4,
      borderLeftColor: R.colors.blue500,
      shadowColor: R.colors.black,
      shadowOffset: {
        width: 0,
        height: 2,
      },
      shadowOpacity: 1,
      shadowRadius: 1,
      elevation: 2,
    },
    eventTimeContainer: {
      minWidth: 80,
      alignItems: 'flex-start',
      justifyContent: 'flex-start',
      marginRight: 15,
    },
    eventTime: {
      fontSize: R.fontsize.fontsSize12,
      fontFamily: R.fonts.InterMedium,
      color: R.colors.blue500,
      fontWeight: '600',
    },
    eventContent: {
      flex: 1,
    },
    eventTitle: {
      fontSize: R.fontsize.fontsSize12,
      fontFamily: R.fonts.InterMedium,
      color: R.colors.black,
      fontWeight: '600',
      marginBottom: 4,
    },
    eventDescription: {
      fontSize: R.fontsize.fontsSize12,
      fontFamily: R.fonts.InterRegular,
      color: R.colors.grey_800,
    },
});

export {styles, CELL_WIDTH, BOTTOM_SHEET_HEIGHT};
