import React, { useState } from "react";
import {
  Text,
  View,
  TouchableOpacity,
  FlatList,
} from "react-native";
import Header from "../../components/Header/Header";
import ItemEmpty from "../../components/List/ItemEmpty";
import I18n from "../../helper/i18/i18n";
import styles from "./style";
import { useNavigation } from "@react-navigation/native";
import { NEWSDETAILS } from "../../routers/ScreenNames";
const NotificationView = (props) => {
  const {
    dataListTabView,
    activeTab,
    onTabChange,
    dataNotifi,
    getEmptyMessage,
  } = props;
  const navigation = useNavigation();
  const renderTabViewItem = ({ item }) => {
    const isActive = activeTab === item.key;

    return (
      <TouchableOpacity
        style={[styles.tab_button, isActive && styles.tab_button_active]}
        onPress={() => onTabChange(item.key)}
      >
        <Text
          style={styles.tab_button_text}
        >
          {item.title}
        </Text>

      </TouchableOpacity>

    );
  };
  const renderNotificationItem = ({ item }) => (
    <TouchableOpacity style={styles.notification_item}
      onPress={() => navigation.navigate(NEWSDETAILS, { item })}
    >
      <View style={styles.notification_content}>
        <Text style={styles.notification_title} >{item.title_notifi}</Text>
        <Text style={styles.text_content} numberOfLines={3} ellipsizeMode="tail">{item.message}</Text>
        <Text style={[styles.text_content, { alignSelf: 'flex-end' }]} numberOfLines={1} ellipsizeMode="tail">{item.time}</Text>
      </View>
    </TouchableOpacity>
  );
  return (
    <View style={styles.container}>
      <Header
        title={I18n.t("Notification")}
        />

      <View style={styles.container_tab_bar}>
        <FlatList
          data={dataListTabView}
          renderItem={renderTabViewItem}
          keyExtractor={(item) => item.key}
          horizontal
          showsHorizontalScrollIndicator={false}
          
          contentContainerStyle={styles.tabScrollContent}
        />
      </View>

      <View style={styles.content_container}>

        <FlatList
          data={dataNotifi[activeTab] || []}
          showsVerticalScrollIndicator={false}
          contentContainerStyle={{ paddingTop: 10 }}
          renderItem={renderNotificationItem}
          keyExtractor={(item, index) => `${activeTab}-${index}`}
          ListEmptyComponent={() => (
            <ItemEmpty
              title={getEmptyMessage(activeTab)}
            />
          )}
        />
      </View>
      </View>
      );
};

export default NotificationView;

