import { StyleSheet, Text, View, TouchableOpacity, Image } from 'react-native';
import React from 'react';
import R from '../../assets/R';

const CardButtonImage = ({ 
  onPress, 
  text = "Tải ảnh ở đây", 
  width, 
  height = 150,
  disabled = false 
}) => {
  return (
    <TouchableOpacity 
      style={[
        styles.container_image, 
        { width, height },
        disabled && styles.disabled
      ]} 
      onPress={onPress}
      disabled={disabled}
      activeOpacity={0.7}
    >
      <View style={styles.image_placeholder}>
      </View>
      <View>
        <Image 
            source={R.images.icImageDownload}
            style={{width:20,height:20, marginRight:5,marginTop:5}}
        />
      </View>
      <Text style={styles.placeholder_text}>
        {text}
      </Text>
    </TouchableOpacity>
  );
};

export default CardButtonImage;

const styles = StyleSheet.create({
  container_image: {
    justifyContent: 'center',
    alignItems: 'center',
    marginHorizontal:15,
    marginTop:3,
    marginBottom:15,
    borderWidth: 1,
    borderColor: R.colors.blue500,
    borderStyle: 'dashed', 
    borderRadius: 15,
    backgroundColor: R.colors.white, 
    padding: 16,
    flexDirection:'row',
    flex:1,
  },
  
  image_placeholder: {
    position: 'absolute',
    width: '100%',
    height: '100%',
    borderRadius: 10,
  },
  
  placeholder_text: {
    fontSize: R.fontsize.fontsSize14,
    fontWeight: '500',
    color:R.colors.black,
    textAlign: 'center',
    letterSpacing: 0.3,
  },
  
  disabled: {
    opacity: 0.5,
    backgroundColor: R.colors.gray400,
  }
});