import React, { useMemo, useState } from "react";
import { Text, View, StyleSheet } from "react-native";
import TrainingProgramView from "./view";
import R from "../../assets/R";
const TrainingProgram = (props) => {
  const [dataTrainingProgram, setDataTrainingProgram] = useState([
    {
      id: "1",
      type: "title", 
      title: "1. GIỚI THIỆU CHUNG",
    },
    {
      id: "1.1",
      type: "subTitle",
      title: "1.1. Mục tiêu đào tạo",
      content:
        "Chương trình Cử nhân Công nghệ Thông tin đào tạo những cử nhân ngành Công nghệ thông tin có phẩm chất chính trị tốt, có đạo đức nghề nghiệp, có ý thức trách nhiệm tổ chức, và có sức khỏe tốt; nắm vững các kiến thức cơ bản và chuyên môn sâu về công nghệ thông tin (CNTT); đáp ứng các yêu cầu về nghiên cứu phát triển và ứng dụng công nghệ thông tin của xã hội; có năng lực tham mưu, tư vấn và có khả năng tổ chức thực hiện nhiệm vụ với tư cách của một chuyên viên trong lĩnh vực CNTT. Bên cạnh đó, trên cơ sở các kiến thức được trang bị ở trình độ đại học, người học có đủ năng lực từng bước hoàn thiện khả năng độc lập nghiên cứu, tự bồi dưỡng và tiếp tục lên học các trình độ cao hơn.",
    },
    {
      id: "1.2",
      type: "subTitle",
      title: "1.2. Vị trí và khả năng làm việc sau tốt nghiệp",
      content: [
        "Sinh viên tốt nghiệp Chương trình đào tạo Cử nhân Công nghệ Thông tin có khả năng làm việc ở những phạm vi và lĩnh vực khác nhau như:",
        "1) Chuyên viên thiết kế, xây dựng và quản lý các dự án nghiên cứu và ứng dụng CNTT, chủ yếu trong lĩnh vực: giao thông, xây dựng, địa lý, môi trường, viễn thám.",
        "2) Chuyên viên quản lý, giám sát, đầu tư các dự án công nghệ thông tin.",
        "3) Chuyên viên khai thác dữ liệu và thông tin ứng dụng cho các doanh nghiệp trong vấn đề phân tích định lượng.",
        "4) Chuyên viên có kĩ năng phát triển các ứng dụng truyền thông xã hội và công nghệ Web.",
        "5) Cán bộ giảng dạy, nghiên cứu khoa học và ứng dụng CNTT ở các trường đại học và cao đẳng trên cả nước.",
      ],
    },
    {
      id: "1.3",
      type: "subTitle",
      title: "1.3. Quan điểm xây dựng chương trình đào tạo",
      content: [
        "Chương trình được thiết kế sao cho đảm bảo đủ độ phủ, độ sâu nhất định nhằm tạo điều kiện, cơ hội phát triển cho sinh viên làm việc, và có thể tiếp tục nghiên cứu chuyên sâu về các chuyên ngành CNTT, trong đó độ phủ được đặt trọng tâm.",
        "Chương trình được thiết kế với mục tiêu phát triển nguồn nhân lực phục vụ cho công cuộc phát triển và hội nhập của đất nước:",
        "- Đào tạo nguồn nhân lực có khả năng để vận hành, quản lý, giám sát; phân tích và phát triển các ứng dụng công nghệ thông tin tại các doanh nghiệp, các đơn vị không chuyên về CNTT nhằm tạo ra các giá trị lợi ích gia tăng cho các doanh nghiệp;",
        "- Đào tạo nguồn nhân lực có khả năng khai thác dữ liệu và thông tin ứng dụng cho các doanh nghiệp trong vấn đề phân tích định lượng;",
        "- Đào tạo nguồn nhân lực có kĩ năng phát triển ứng dụng truyền thông xã hội và công nghệ Web;",
        "- Đào tạo nguồn nhân lực kỹ thuật tham gia các quy trình thiết kế, xây dựng, quản lý các dự án nghiên cứu và ứng dụng CNTT, chủ yếu trong lĩnh vực: địa lý, môi trường, viễn thám.",
        "Chương trình được thiết kế, xây dựng dựa vào tầm nhìn và sứ mệnh nhà trường; phiếu góp ý của doanh nghiệp, sinh viên tốt nghiệp, giảng viên giảng dạy và tài liệu tham khảo chính là Chương trình đào tạo Đại học về Công nghệ Thông tin của ACM (Association for Computing Machinery) và IEEE Computer Society ấn hành.",
      ],
    },
  ]);

   const hasContent = (item) => {
    if (!item.content) return false;
    if (Array.isArray(item.content)) {
      return item.content.length > 0;
    }
    return item.content.trim().length > 0;
  };
  const processItemContent = (item) => {
    if (!hasContent(item)) return null;
    
    if (Array.isArray(item.content)) {
      return item.content.map((line, index) => (
        <Text 
          key={`${item.id}-content-${index}`} 
          style={styles.listItem}
        >
          {line}
        </Text>
      ));
    } else {
      return (
        <Text style={styles.paragraph}>
          {item.content}
        </Text>
      );
    }
  };

 const enhancedDataTrainingProgram = useMemo(() => {
    return dataTrainingProgram.map(item => ({
      ...item,
      hasContentFlag: hasContent(item),
      processedContent: processItemContent(item)
    }));
  }, [dataTrainingProgram]);

  return <TrainingProgramView dataTrainingProgram={enhancedDataTrainingProgram} />;
};

export default TrainingProgram;
const styles = {
  paragraph: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    textAlign: "justify",
    fontFamily: R.fonts.InterSemiBold,
  },
  listItem: {
    fontSize: R.fontsize.fontSizeContent,
    lineHeight: 20,
    color: R.colors.black,
    fontFamily: R.fonts.InterSemiBold,
  },
};