import { StyleSheet } from 'react-native'
import R from '../../assets/R'

const styles = StyleSheet.create({
    container: {
        flex: 1,
        paddingHorizontal: 15,
        paddingBottom: 9,
        backgroundColor: R.colors.white
      },
      body_header: {
        flexDirection: "row",
      },
      container_image: {
        flex: 1,
        alignItems: "flex-start",
        justifyContent: "flex-start",
      },
      container_body: {
        flexDirection: "row",
        marginTop: 10,
        marginBottom: 5
      },
      images: {
        backgroundColor: R.colors.grey_50,
        minWidth: 108,
        minHeight: 177,
        borderRadius: 15,
        borderWidth: 1,
        borderColor: R.colors.grey_200,
        justifyContent: "center",
        alignItems: "center",
      },
      body_info_user: {
        flex: 1.8,
      },
      text: {
        fontFamily: R.fonts.InterRegular,
        fontWeight: "400",
        fontSize: R.fontsize.fontsSize12,
        color: R.colors.blue500,
        lineHeight: 24
      },
      
      text_label: {
        fontFamily: R.fonts.InterRegular,
        fontWeight: "400",
        fontSize: R.fontsize.fontsSize12,
        color: R.colors.grey_100,
      },
      text_button: {
        fontFamily: R.fonts.InterRegular,
        fontWeight: "400",
        fontSize: R.fontsize.fontsSize12,
        color: R.colors.white,
      },
      body: {
        marginTop: 11,
      },
      text_check_box_label: {
        fontFamily: R.fonts.InterRegular,
        fontWeight: "400",
        fontSize: R.fontsize.fontsSize12,
        color: R.colors.black_800,
        alignSelf: "center"
      },
      text_check_box: {
        fontFamily: R.fonts.InterRegular,
        fontWeight: "400",
        fontSize: R.fontsize.fontsSize12,
        color: R.colors.blue500,
      },
      container_body_footer: {
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        marginVertical: 5,
      },
})

export default styles