import {Image, StyleSheet, Text, View} from 'react-native';
import React from 'react';
import R from '../../../assets/R';
import Button from '../../../components/Button';
import {useNavigation} from '@react-navigation/native';
import * as ScreenName from '../../../routers/ScreenNames';
import styles from '../style';
const ItemNav = () => {
  const navigate = useNavigation();
  return (
    <View style={styles.container_card}>
      <View style={styles.header_card_item}>
        <Text style={styles.text_title_left}>Chứng chỉ toeic</Text>

        <Text
          onPress={() => {
            navigate.navigate(ScreenName.DETAILCERTIFICATE);
          }}
          style={styles.text_title_right}>
          Chi tiết
        </Text>
      </View>
      <View style={styles.image_container}>
        <Image source={R.images.igProfileDemo} style={styles.image_item} />
      </View>
      <View style={styles.footer_card_item}>
        <View>
          <Text style={[styles.sub_text,styles.text_bold]}>Trạng thái:{' '}
            <Text style={{fontWeight: '400'}}>Đang đánh giá</Text></Text>
          <Text style={[styles.sub_text,styles.text_bold]}>Ngày đăng ký:{' '}
            <Text style={{fontWeight: '400'}}>23/10/2024</Text></Text>
          <Text style={[styles.sub_text,styles.text_bold, {color: R.colors.blue500}]}>
            Không dùng để đăng ký học bổng
          </Text>
        </View>
        <View style={styles.button_container}>
          <Button
            title={'Huỷ'}
            fontFamily={R.fonts.InterRegular}
            fontWeight={300}
            fontSize={14}
            width={61}
            height={27}
            backgroundColor={R.colors.red}
            borderRadius={10}
            textColor={R.colors.white}
          />
        </View>
      </View>
    </View>
  );
};

export default ItemNav;
