import React from 'react';
import {Text, View, Image, ScrollView} from 'react-native';
import R from '../../../assets/R';
import Header from '../../../components/Header/Header';
import styles from '../style';

const DetailCertificateView = props => {
  return (
    <View style={{flex: 1}}>
      <Header isBack={true} title={'Chứng chỉ toeic'} />
      <ScrollView
        showsVerticalScrollIndicator={false}
        style={styles.container_detail}>
        <View style={styles.container_card_detail}>
          <View style={styles.status}>
            <Text
              style={[
                styles.text_title,
                {
                  color: R.colors.white,
                  fontWeight: '800',
                  fontSize: R.fontsize.fontsSize12,
                },
              ]}>
              Chứng chỉ đang được đánh giá
            </Text>
          </View>
          <View style={styles.card_item}>
            <View style={styles.header_card_item}>
              <Text style={[styles.text_title, styles.text_bold]}>
                Chứng chỉ toeic
              </Text>
            </View>
            <View style={styles.image_container}>
              <Image
                source={R.images.igProfileDemo}
                style={styles.imageDetail}
              />
            </View>
            <View>
              <Text style={[styles.sub_text_detail, styles.text_bold]}>
                Loại chứng chỉ:{' '}
                <Text style={[styles.sub_text_detail]}>TOEIC</Text>
              </Text>
              <Text style={[styles.sub_text_detail, styles.text_bold]}>
                Ngày sinh:{' '}
                <Text style={[styles.sub_text_detail]}>23/10/2004</Text>
              </Text>

              <Text style={[styles.sub_text_detail, styles.text_bold]}>
                CCCD/CMND đăng ký:{' '}
                <Text style={[styles.sub_text_detail]}>00228956325</Text>
              </Text>
              <Text style={[styles.sub_text_detail, styles.text_bold]}>
                Ngày thi:{' '}
                <Text style={[styles.sub_text_detail]}>23/10/2024</Text>
              </Text>
              <Text style={[styles.sub_text_detail, styles.text_bold]}>
                Tổng điểm:{' '}
                <Text style={[styles.sub_text_detail]}>875</Text>
              </Text>
              <View
                style={{
                  flexDirection: 'row',
                  justifyContent: 'space-between',
                }}>
                <Text style={[styles.sub_text_detail, styles.text_bold]}>Điểm nói:{' '}
                <Text style={[styles.sub_text_detail]}>0</Text></Text>
                <Text style={[styles.sub_text_detail, styles.text_bold]}>Điểm nghe:{' '}
                <Text style={[styles.sub_text_detail]}>445</Text></Text>
              </View>
              <View
                style={{
                  flexDirection: 'row',
                  justifyContent: 'space-between',
                }}>
                <Text style={[styles.sub_text_detail, styles.text_bold]}>Điểm đọc:{' '}
                <Text style={[styles.sub_text_detail]}>430</Text></Text>
                <Text style={[styles.sub_text_detail, styles.text_bold]}>Điểm viết:{' '}
                <Text style={[styles.sub_text_detail]}>0</Text></Text>
              </View>
              <Text style={[styles.sub_text_detail, styles.text_bold]}>Số TRF:{' '}
              <Text style={[styles.sub_text_detail]}>085692265852</Text></Text>
              <Text style={[styles.sub_text_detail, styles.text_bold]}>
                Có hiệu lực đến:{' '}
                <Text style={[styles.sub_text_detail]}>23/10/2026</Text>
              </Text>
              <Text style={[styles.sub_text_detail, {color: R.colors.main , fontWeight: '800'}]}>
                Không dùng để đăng ký học bổng
              </Text>
            </View>
          </View>
        </View>
      </ScrollView>
    </View>
  );
};

export default DetailCertificateView;
