import React from "react";
import {
  Text,
  View,
  StyleSheet,
  SafeAreaView,
  ScrollView,
  Dimensions,
} from "react-native";
import {
  Table,
  TableWrapper,
  Row,
  Cell,
} from 'react-native-reanimated-table';
import Header from "../../../components/Header/Header";
import R from "../../../assets/R";

const DetailRollCallView = (props) => {
  const { dataTitle, dataListInfo } = props;
  const STT_COLUMN_WIDTH = 40;
  const DEFAULT_COLUMN_WIDTH = 140;

  const getColumnWidths = () => {
    return dataTitle.map((title, index) => {
      return index === 0 ? STT_COLUMN_WIDTH : DEFAULT_COLUMN_WIDTH;
    });
  };

  const columnWidths = getColumnWidths();

  const totalTableWidth = columnWidths.reduce((sum, width) => sum + width, 0);

  const renderCustomHeader = () => {
    return (
      <View style={styles.customHeaderRow}>
        {dataTitle.map((title, index) => (
          <View
            key={`header-${index}`}
            style={[
              styles.customHeaderCell,
              { width: columnWidths[index] },
              index === 0 && styles.headerCellFirst,
              index === dataTitle.length - 1 && styles.headerCellLast,
            ]}
          >
            <Text style={styles.headerText} numberOfLines={2}>
              {title}
            </Text>
          </View>
        ))}
      </View>
    );
  };

  return (
    <View style={styles.container}>
       <Header
        isBack
        title={'Thông tin điểm danh lớp ADCV'}
      />
    <View style={styles.container}>
     

      <ScrollView
        style={styles.outerScrollView}
        showsVerticalScrollIndicator={false}
        contentContainerStyle={styles.outerScrollContent}
      >
        <View style={styles.tableContainer}>
          <ScrollView
            horizontal
            showsHorizontalScrollIndicator={false}
            showsVerticalScrollIndicator={false}
            style={styles.horizontalScroll}
            contentContainerStyle={styles.scrollContent}
            nestedScrollEnabled={true}
          >
            <View style={[styles.tableWrapper, { width: totalTableWidth }]}>
              {renderCustomHeader()}

              <View style={styles.tableBody}>
                {dataListInfo.map((rowData, rowIndex) => (
                  <View
                    key={`row-${rowIndex}`}
                    style={styles.customTableRow}
                  >
                    {rowData.map((cellData, cellIndex) => (
                      <View
                        key={`cell-${rowIndex}-${cellIndex}`}
                        style={[
                          styles.customTableCell,
                          { width: columnWidths[cellIndex] },
                          cellIndex < rowData.length - 1 && styles.cellBorderRight,
                          rowIndex < dataListInfo.length - 1 && styles.cellBorderBottom,
                        ]}
                      >
                        <Text
                          style={[styles.cellText, cellData.style]}
                          numberOfLines={2}
                          ellipsizeMode="tail"
                        >
                          {cellData.content}
                        </Text>
                      </View>
                    ))}
                  </View>
                ))}
              </View>
            </View>
          </ScrollView>
        </View>

      </ScrollView>
    </View>
    </View>
  );
};

export default DetailRollCallView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },

  outerScrollView: {
    flex: 1,
  },

  outerScrollContent: {
    flexGrow: 1,
  },

  tableContainer: {
    paddingVertical: 10,
  },

  horizontalScroll: {
  },

  scrollContent: {
    paddingHorizontal: 15,
  },

  tableWrapper: {
    borderWidth: 1,
    borderColor: R.colors.grey_200,
    overflow: 'hidden',
  },

  customHeaderRow: {
    flexDirection: 'row',
    backgroundColor: R.colors.grey_200,
    minHeight: 50,
  },

  customHeaderCell: {
    justifyContent: 'center',
    alignItems: 'center',
    paddingHorizontal: 4,
    borderRightWidth: 1,
    borderRightColor: R.colors.grey_200,
  },

  headerCellFirst: {
    borderTopLeftRadius: 7,
  },

  headerCellLast: {
    borderTopRightRadius: 7,
    borderRightWidth: 0,
  },

  tableBody: {
    backgroundColor: R.colors.white,
  },

  customTableRow: {
    flexDirection: 'row',
    minHeight: 45,
  },

  customTableCell: {
    justifyContent: 'center',
    alignItems: 'center',
    paddingHorizontal: 4,
    backgroundColor: R.colors.white,
  },

  cellBorderRight: {
    borderRightWidth: 1,
    borderRightColor: R.colors.grey_200,
  },

  cellBorderBottom: {
    borderBottomWidth: 1,
    borderBottomColor: R.colors.grey_200,
  },

  headerText: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '400',
    color: R.colors.black,
    textAlign: 'center',
  },

  cellText: {
    fontFamily: R.fonts.InterRegular,
    fontSize: R.fontsize.fontsSize10,
    fontWeight: '400',
    color: R.colors.black,
    textAlign: 'center',
  },

});