import React from "react";
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  ScrollView,
  SafeAreaView,
  TextInput,
} from "react-native";
import R from "../../assets/R";
import Header from "../../components/Header/Header";
import Button from "../../components/Button";
import DropdownSelect from "../../components/Dropdown/DropdownSel";
import Checkbox from "../../components/CheckBox";
import CustomTextInput from "../../components/Input/TextFieldCus";
const ProfileView = (props) => {
  const { phone, setPhone, cmnd, setCmnd, bank, setBank } = props;
  const IconCamera = R.images.icCamera;
  return (
     <View style={{ flex: 1, backgroundColor:R.colors.white}}>
        <Header title={"Hồ sơ cá nhân"} isBack />
          <ScrollView showsVerticalScrollIndicator={false} style={{ flex: 1 , backgroundColor:R.colors.white}}>
        <View style={styles.container}>
          <View style={styles.body_header}>
            <View style={styles.container_image}>
              <TouchableOpacity style={styles.images}>
                <View style={{ alignItems: "center" }}>
                  <IconCamera />
                </View>
              </TouchableOpacity>
              <Button
                width={110}
                height={30}
                marginHorizontal={0}
                marginTop={11}
                borderRadius={10}
                textColor={R.colors.white}
                fontFamily={R.fonts.InterRegular}
                fontSize={R.fontsize.fontsSize12}
                fontWeight={"400"}
                backgroundColor={R.colors.main}
                title={"Chọn ảnh"}
              />
            </View>
            <View style={styles.body_info_user}>
              <Text style={styles.text}>Họ và tên: Nguyễn Minh Duy</Text>
              <Text style={styles.text}>Giới tính: Nam</Text>
              <Text style={styles.text}>Năm sinh : 23/10/2003</Text>
              <Text style={styles.text}>Mã sinh viên: PH32251</Text>
              <Text style={styles.text}>Khoa: Khoa học máy tính</Text>
              <Text style={styles.text}>Chuyên ngành lập trình web</Text>
              <View style={{ marginTop: 15 }}>
                <Text style={styles.text_label}>
                  Ảnh chụp thẳng, nền TRẮNG hoặc XANH, mặc áo có cổ; tỷ lệ 4x6,
                  dung lượng từ 200 đến 500 KB
                </Text>
              </View>
            </View>
          </View>
          <View style={styles.body}>
            <View style={{ flexDirection: "row" }}>
              <View style={{ flex: 1 }}>
                <DropdownSelect
                  title={"Dân tộc *"}
                  placeholder="Kinh"
                  placeholderColor={R.colors.gray800}
                  placeholderFontFamily={R.fonts.InterRegular}
                  placeholderFontSize={R.fontsize.fontsSize10}
                  placeholderFontWeight={"400"}
                  borderRadius={10}
                  height={40}
                  iconSize={10}
                  iconColor={R.colors.black}
                  titleFontWeight={"400"}
                  titleFontSize={R.fontsize.fontsSize12}
                  fontSize={R.fontsize.fontsSize12}
                  titleFontFamily={R.fonts.InterRegular}
                  marginHorizontal={0}
                  marginVertical={0}
                />
              </View>
              <View style={{ width: '5%' }}></View>
              <View style={{ flex: 1 }}>
                <DropdownSelect
                  title={"Tôn giáo *"}
                  placeholder="Không"
                  placeholderColor={R.colors.gray800}
                  placeholderFontFamily={R.fonts.InterRegular}
                  placeholderFontSize={R.fontsize.fontsSize10}
                  placeholderFontWeight={"400"}
                  borderRadius={10}
                  height={40} 
                  iconSize={10}
                  iconColor={R.colors.black}
                  titleFontWeight={"400"}
                  titleFontSize={R.fontsize.fontsSize12}
                  fontSize={R.fontsize.fontsSize12}
                  titleFontFamily={R.fonts.InterRegular}
                  marginHorizontal={0}
                  marginVertical={0}
                />
              </View>
            </View>
            <View
              style={styles.container_body}
            >
              <View style={{ flex: 1 }}>
                <DropdownSelect
                  title={"Thành phần xuất thân *"}
                  titleFontWeight={"400"}
                  titleFontSize={R.fontsize.fontsSize12}
                  titleFontFamily={R.fonts.InterRegular}
                  placeholder="Khác"
                  placeholderColor={R.colors.gray800}
                  placeholderFontFamily={R.fonts.InterRegular}
                  placeholderFontSize={R.fontsize.fontsSize10}
                  placeholderFontWeight={"400"}
                  borderRadius={10}
                  height={40}
                  iconSize={10}
                  iconColor={R.colors.black}
                  fontSize={R.fontsize.fontsSize12}
                  marginHorizontal={0}
                  marginVertical={0}
                />
              </View>
              <View style={{ width: '5%' }}></View>
              <View style={{ flex: 1 }}>
                <DropdownSelect
                  title={"Nơi sinh *"}
                  placeholder="Tỉnh kiên giang"
                  placeholderColor={R.colors.gray800}
                  placeholderFontFamily={R.fonts.InterRegular}
                  placeholderFontSize={R.fontsize.fontsSize10}
                  placeholderFontWeight={"400"}
                  fontSize={R.fontsize.fontsSize12}
                  borderRadius={10}
                  backgroundColor={R.colors.greyBlue_soft_50}
                  height={40}
                  iconSize={10}
                  iconColor={R.colors.black}
                  titleFontWeight={"400"}
                  titleFontSize={R.fontsize.fontsSize12}
                  titleFontFamily={R.fonts.InterRegular}
                  marginHorizontal={0}
                  marginVertical={0}
                />
              </View>
            </View>
            <CustomTextInput
              title={"Điện thoại cá nhân "}
              placeholder="Điện thoại cá nhân"
              required={true}
              value={phone}
              onChangeText={setPhone}
              keyboardType="phone-pad"
            />

            <CustomTextInput
              title={"CMND/CCCD"}
              placeholder="CMND/CCCD"
              required={true}
              value={cmnd}
              onChangeText={setCmnd}
              keyboardType="phone-pad"
              backgroundColor={R.colors.greyBlue_soft_50}
            />

            <CustomTextInput
              title={"Ngày cấp CMND/CCCD"}
              placeholder="17/01/2021"
              required={true}
              value={cmnd}
              onChangeText={setCmnd}
              keyboardType="default"
              backgroundColor={R.colors.greyBlue_soft_50}
            />

            <CustomTextInput
              title={"Nơi cấp CMND/CCCD"}
              placeholder="Cục cảnh sát quản lý hành chính Hà Nội"
              required={true}
              value={cmnd}
              onChangeText={setCmnd}
              keyboardType="phone-pad"
              backgroundColor={R.colors.greyBlue_soft_50}
            />

            <Text style={[styles.text, { lineHeight: 16 }]}>
              Thông tin tài khoản ngân hàng của sinh viên (Tài khoản chính chủ
              của sinh viên, không được là số tài khoản của người khác)
            </Text>
            <CustomTextInput
              title={"Thông tin ngân hàng"}
              placeholder="Thông tin ngân hàng"
              required={true}
              value={bank}
              onChangeText={setBank}
            />
            <CustomTextInput
              title={"Số tài khoản"}
              placeholder="Số tài khoản"
              required={true}
              value={bank}
              onChangeText={setBank}
            />

            <CustomTextInput
              title={"Chi nhánh"}
              placeholder="Chi nhánh"
              required={true}
              value={bank}
              onChangeText={setBank}
            />

            <CustomTextInput
              title={"Email cá nhân"}
              placeholder="Email cá nhân"
              required={true}
              value={bank}
              onChangeText={setBank}
            />

            <CustomTextInput
              title={"Địa chỉ facebook"}
              placeholder="Địa chỉ facebook"
              required={true}
              value={bank}
              onChangeText={setBank}
            />

            <CustomTextInput
              title={"Địa chỉ thường trú"}
              placeholder="Địa chỉ thường trú"
              required={true}
              value={bank}
              onChangeText={setBank}
            />

            <DropdownSelect
              title={"Tỉnh/ TP-54"}
              placeholder="Hà Nội"
              placeholderColor={R.colors.gray800}
              borderRadius={10}
              iconSize={10}
              placeholderFontFamily={R.fonts.InterRegular}
              placeholderFontSize={R.fontsize.fontsSize10}
              placeholderFontWeight={"400"}
              height={40}
              marginHorizontal={0}
              iconColor={R.colors.black}
              titleFontWeight={"400"}
              titleFontSize={R.fontsize.fontsSize12}
              fontSize={R.fontsize.fontsSize12}
              marginVertical={5}
              titleFontFamily={R.fonts.InterRegular}
              backgroundColor={R.colors.greyBlue_soft_50}
            />
            <DropdownSelect
              title={"Phường/Xã"}
              placeholder="Hà Nội"
              placeholderColor={R.colors.gray800}
              borderRadius={10}
              iconSize={10}
              placeholderFontFamily={R.fonts.InterRegular}
              placeholderFontSize={R.fontsize.fontsSize10}
              placeholderFontWeight={"400"}
              height={40}
              marginHorizontal={0}
              iconColor={R.colors.black}
              titleFontWeight={"400"}
              titleFontSize={R.fontsize.fontsSize12}
              fontSize={R.fontsize.fontsSize12}
              titleFontFamily={R.fonts.InterRegular}
              marginVertical={5}
              backgroundColor={R.colors.greyBlue_soft_50}
            />

      
            <View style={styles.container_body_footer}>
              <Checkbox
                label={"Đoàn viên?"}
                labelStyle={styles.text_check_box}
                size={14}
                borderColor={R.colors.blue500}
              />
              <View style={{ flex: 1, marginLeft: 16 }}>
                <Text style={styles.text_check_box_label}>
                  Ngày vào đoàn
                </Text>
              </View>
              <View style={{ flex: 1.2 }}>
                <CustomTextInput
                  placeholder="Ngày vào đoàn"
                  required={true}
                  value={bank}
                  onChangeText={setBank}
                />
              </View>
            </View >
            <View style={styles.container_body_footer}>
              <Checkbox
                label={"Đảng viên?"}
                labelStyle={styles.text_check_box}
                size={14}
                borderColor={R.colors.blue500}
              />
              <View style={{ flex: 1, marginLeft: 16 }}>
                <Text style={styles.text_check_box_label}>
                  Ngày vào đảng
                </Text>
              </View>
              <View style={{ flex: 1.2 }}>
                <CustomTextInput
                  placeholder="Ngày vào đoàn"
                  required={true}
                  value={bank}
                  onChangeText={setBank}
                />
              </View>
            </View>

            <Button
              title={'Cập nhật'}
              onPress={() => {}}
              backgroundColor={R.colors.blue500}
              height={30}
              textStyle={styles.text_button}
              marginHorizontal={0}
              marginVertical={0}
              borderRadius={10}
              textColor={R.colors.white}
            />
          </View>
        </View>
        </ScrollView>
      </View>
  );
};

export default ProfileView;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    paddingHorizontal: 15,
    paddingBottom: 9,
    backgroundColor: R.colors.white
  },
  body_header: {
    flexDirection: "row",
  },
  container_image: {
    flex: 1,
    alignItems: "flex-start",
    justifyContent: "flex-start",
  },
  container_body: {
    flexDirection: "row",
    marginTop: 10,
    marginBottom: 5
  },
  images: {
    backgroundColor: R.colors.grey_50,
    minWidth: 108,
    minHeight: 177,
    borderRadius: 15,
    borderWidth: 1,
    borderColor: R.colors.grey_200,
    justifyContent: "center",
    alignItems: "center",
  },
  body_info_user: {
    flex: 1.8,
  },
  text: {
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.blue500,
    lineHeight: 24
  },
  
  text_label: {
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.grey_100,
  },
  text_button: {
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.white,
  },
  body: {
    marginTop: 11,
  },
  text_check_box_label: {
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.black_800,
    alignSelf: "center"
  },
  text_check_box: {
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.blue500,
  },
  container_body_footer: {
    flexDirection: "row",
    alignItems: "center",
    justifyContent: "space-between",
    marginVertical: 5,
  },
});
