import { StyleSheet, Text, View } from "react-native";
import React from "react";
import R from "../../assets/R";

const ItemNav = ({ item }) => {
  return (
    <View style={styles.container}>
      <Text style={styles.text}>{item.address}</Text>
      <Text style={[styles.text,{fontFamily:R.fonts.InterRegular}]}>Thời gian cứ trú: {item.timeStay}</Text>
      <View style={{ flexDirection: "row"}}>
        <Text style={[styles.text, { flex: 3,fontFamily:R.fonts.InterRegular }]}>Ngày đăng kí: {item.registrationDate}</Text>
        <View style={[styles.text, { flex:2.5,fontFamily:R.fonts.InterRegular }]}>
          <Text
            style={[
              styles.text,
              {alignSelf:'flex-end'},
              item.statusColor && { color: item.statusColor },
            ]}
          >
            {item.status}
          </Text>
        </View>
      </View>
      <Text style={[styles.text, { fontFamily:R.fonts.InterRegular }]}>Quan hệ với chủ trọ:{item.relation}</Text>
      <Text style={[styles.text, { fontFamily:R.fonts.InterRegular }] }>Lý do: {item.reason}</Text>
    </View>
  );
};

export default ItemNav;

const styles = StyleSheet.create({
  container: {
    backgroundColor: R.colors.white ,
    borderRadius: 15,
    marginBottom: 18,
    padding: 15,
    shadowColor: R.colors.black,
    shadowOffset: {
      width: 0,
      height:2
    },
    shadowOpacity: 0.5,
    shadowRadius: 1,
    elevation: 1,
  },
  
  text: {
    fontSize: R.fontsize.fontsSize12,
    fontWeight: "600",
    color: R.colors.black,
    fontFamily: R.fonts.InterMedium,
  },
});
