import React, { useMemo, useState } from "react";
import { Text, View, StyleSheet } from "react-native";
import OutpatientInfomationView from "./view";
import R from "../../assets/R";

const OutpatientInfomation = (props) => {
   const [isModalVisible, setIsModalVisible] = useState(false);
    const handleOpenRegistrationModal = () => {
    setIsModalVisible(true);
  };
  const handleCloseModal = () => {
    setIsModalVisible(false);
  };
  const handleNavigateToOther = () => {
    navigation?.navigate('OtherRegistrationScreen');
  };
   const handleSubmitRegistration = (selectedOptions) => {
    console.log('Selected registration options:', selectedOptions);
    
  };
  const [dataTitle] = useState([
    "STT",
    "Địa chỉ",
    "Quan hệ chủ hộ",
    "Thời gian cư trú",
  ]);
  const [listInfo, setListDataInfo] = useState([
    {
      address: "134/44/9 Nguyên xá, Bắc Từ Liêm, Hà Nội",
      timeStay: "25/05/2025 - Hiện tại",
      registrationDate: "23/05/2025",
      status: "Đã phê duyệt",
      relation: "Chủ trọ",
      reason: "",
    },
    {
      address: "23 Nguyễn Trãi, Thanh Xuân, Hà Nội",
      timeStay: "10/03/2024 - 20/05/2025",
      registrationDate: "05/03/2024",
      status: "Chờ phê duyệt",
      relation: "Anh/em",
      reason: "Chuyển công tác",
    },
    {
      address: "102/12 Trường Chinh, Đống Đa, Hà Nội",
      timeStay: "15/01/2023 - 01/03/2024",
      registrationDate: "12/01/2023",
      status: "Từ chối",
      relation: "Bạn bè",
      reason: "Thông tin không khớp",
    },
     {
      address: "102/12 Trường Chinh, Đống Đa, Hà Nội",
      timeStay: "15/01/2023 - 01/03/2024",
      registrationDate: "12/01/2023",
      status: "Từ chối",
      relation: "Bạn bè",
      reason: "Thông tin không khớp",
    },
     {
      address: "102/12 Trường Chinh, Đống Đa, Hà Nội",
      timeStay: "15/01/2023 - 01/03/2024",
      registrationDate: "12/01/2023",
      status: "Từ chối",
      relation: "Bạn bè",
      reason: "Thông tin không khớp",
    },
    
  ]);
      const getStatusColor = (status) => {
    switch (status) {
      case 'Đã phê duyệt':
        return R.colors.green ;
      case 'Từ chối':
        return R.colors.red ;
      case 'Chờ phê duyệt':
        return R.colors.orange ;
      default:
        return R.colors.black;
    }
  };

  const processedData = useMemo(() => {
    return listInfo.map((item) => ({
      ...item,
      statusColor: getStatusColor(item.status), 
    }));
  }, [listInfo]);
  return <OutpatientInfomationView 
            dataTitle={dataTitle} 
            dataList={processedData}
            isModalVisible={isModalVisible}
            onOpenRegistrationModal={handleOpenRegistrationModal}
            onCloseModal={handleCloseModal}
            onNavigateToOther={handleNavigateToOther}
            onSubmitRegistration={handleSubmitRegistration}
      
      
            />;
};

export default OutpatientInfomation;
