
import R from "../../assets/R";
import { Text, View, TouchableOpacity, StyleSheet, Image } from 'react-native';

const ItemView = ({item}) => {
  return (
    <TouchableOpacity style={styles.container}>
        <Text style={styles.text_title}>Mã môn học: {item.code_exam}</Text>
        <Text style={styles.text_title}>Mã lớp: {item.code_class}</Text>

        <View style={styles.content}>
            <Text style={styles.text_content}>Ca/Tiết thi: {item.poetry}</Text>
            <Text style={styles.text_content}>Thứ thi: {item.day_exam}</Text>
        </View>
        <View style={styles.content}>
            <Text style={styles.text_content}>Ngày thi: {item.time_exam}</Text>
            <Text style={styles.text_content}>Phòng thi: {item.class_exam}</Text>
        </View>
        <Text style={styles.text_content}>Ghi chú/ hình thức thi: {item.description}</Text>

    </TouchableOpacity>
  );
};

export default ItemView;
const styles = StyleSheet.create({
  container: {
    borderRadius: 10,
    paddingHorizontal: 14,
    paddingVertical: 10,
    marginBottom: 10,
    shadowColor: R.colors.black,
    shadowOffset: {
      width: 0,
      height:2
    },
    shadowOpacity: 0.5,
    shadowRadius: 2,
    elevation: 1,
    backgroundColor: R.colors.white,
    marginVertical: 5,
    marginHorizontal:10
  },
  content: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
  },
  text_title: {
    fontSize: R.fontsize.fontsSize12,
    fontWeight: '500',
    color: R.colors.blue500,
    fontFamily: R.fonts.InterSemiBold,
  },
  text_content: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.black,
    fontWeight: '400',
    fontFamily: R.fonts.InterRegular,
  },
});
