import React, { useState, useMemo } from "react";
import {
  Text,
  View,
  StyleSheet,
  Modal,
  Pressable,
  Image,
  Touchable,
  TouchableOpacity,
} from "react-native";
import DebtView from "./view";
import R from "../../assets/R";
const Debt = (props) => {
  const [activeTab, setActiveTab] = useState("WFP");
  const IconImage = R.images.icImage;
  const [dataListStatus, setDataListStatus] = useState([
    { key: "WFP", title_status: "Chờ thanh toán" },
    { key: "P", title_status: "Đã thanh toán" },
    { key: "O", title_status: "Quá hạn" },
  ]);
  const handleTabChange = (tabKey) => {
    setActiveTab(tabKey);
  };
  const closeModal = () => {
    setModalVisible(false);
  };

  const [dataListDebtItem, setDataListDebtItem] = useState([
    {
      id: 1,
      title_notifi_student_code:
        "Trường thông báo sinh viên 086592 cần thanh toán khoản công nợ thư viện",
      price: 50000,
      code_debt: "hfhfkYRBFI37457HDNNF",
      type_debt: "Đã thanh toán",
      message_debt: "Em cần thanh toán nợ từ việc làm mất sách của trường",
      payment_term: "23/07/2025",
      status: "P",
    },
    {
      id: 2,
      title_notifi_student_code:
        "Trường thông báo sinh viên 086592 cần thanh toán khoản công nợ thư viện",
      price: 50000,
      code_debt: "hfhfkYRBFI37457HDNNF",
      type_debt: "Nợ thư viện",
      message_debt: "Em cần thanh toán nợ từ việc làm mất sách của trường",
      payment_term: "23/07/2025",
      status: "O",
    },
    {
      id: 3,
      title_notifi_student_code:
        "Trường thông báo sinh viên 086592 cần thanh toán khoản công nợ thư viện",
      price: 50000,
      code_debt: "hfhfkYRBFI37457HDNNF",
      type_debt: "Chờ thanh toán",
      message_debt: "Em cần thanh toán nợ từ việc làm mất sách của trường",
      payment_term: "23/07/2025",
      status: "WFP",
    },
    {
      id: 4,
      title_notifi_student_code:
        "Trường thông báo sinh viên 086592 cần thanh toán khoản công nợ thư viện",
      price: 50000,
      code_debt: "hfhfkYRBFI37457HDNNF",
      type_debt: "Chờ thanh toán",
      message_debt: "Em cần thanh toán nợ từ việc làm mất sách của trường",
      payment_term: "23/07/2025",
      status: "WFP",
    },  
    {
      id: 5,
      title_notifi_student_code:
        "Trường thông báo sinh viên 086592 cần thanh toán khoản công nợ thư viện",
      price: 50000,
      code_debt: "hfhfkYRBFI37457HDNNF",
      type_debt: "Chờ thanh toán",
      message_debt: "Em cần thanh toán nợ từ việc làm mất sách của trường",
      payment_term: "23/07/2025",
      status: "WFP",
    },  
     {
      id: 6,
      title_notifi_student_code:
        "Trường thông báo sinh viên 086592 cần thanh toán khoản công nợ thư viện",
      price: 50000,
      code_debt: "hfhfkYRBFI37457HDNNF",
      type_debt: "Chờ thanh toán",
      message_debt: "Em cần thanh toán nợ từ việc làm mất sách của trường",
      payment_term: "23/07/2025",
      status: "WFP",
    },  

  ]);
  const [timeDebt, setTimeDebt] = useState("Hôm nay, 21/07/2025");

  const getItemDisplayConfig = (status, type_debt) => {
    switch (status) {
      case "WFP": // Chờ thanh toán
        return {
          titleColor:
            type_debt === "Nợ thư viện" ? R.colors.red : R.colors.black,
          priceColor: R.colors.textSubMain,
          timeColor: R.colors.red,
          typeDebtColor: R.colors.black,
          showButton: true,
          showPaymentTerm: true,
        };

      case "P":
        return {
          titleColor: R.colors.black,
          priceColor: R.colors.green,
          timeColor: false,
          typeDebtColor: R.colors.black,
          showButton: false,
        };

      case "O": // Quá hạn
        return {
          titleColor: R.colors.red,
          priceColor: R.colors.textSubMain,
          timeColor: R.colors.red,
          typeDebtColor: R.colors.black,
          showButton: true,
          showPaymentTerm: true,
        };
    }
  };
  const handlePayPress = (item) => {
    setModalVisible(true);
    console.log("Đã bấm Thanh toán:", item);
  };
  const [modalVisible, setModalVisible] = useState(false);
  const processedDebtItems = useMemo(() => {
    return dataListDebtItem.map((item) => {
      const displayConfig = getItemDisplayConfig(item.status, item.type_debt);

      return {
        id: item.id,
        title_notifi_student_code: item.title_notifi_student_code,
        price: item.price,
        code_debt: item.code_debt,
        type_debt: item.type_debt,
        message_debt: item.message_debt,
        payment_term: item.payment_term,
        status: item.status,
        displayConfig: displayConfig,
      };
    });
  }, [dataListDebtItem]);

  return (
    <>
      <DebtView
        onTabChange={handleTabChange}
        activeTab={activeTab}
        dataListStatus={dataListStatus}
        dataListDebtItem={processedDebtItems}
        timeDebt={timeDebt}
        onPayPress={handlePayPress}
      />
      <Modal
        visible={modalVisible}
        transparent
        animationType="slide"
        onRequestClose={() => setModalVisible(false)}
      >
        <Pressable
          style={{
            flex: 1,
            justifyContent: "center",
            alignItems: "center",
            backgroundColor: "rgba(0, 0, 0, 0.55)",
          }}
          onPress={closeModal}
        >
          <View
            style={{
              padding: 20,
              backgroundColor: "white",
              borderRadius: 10,
            }}
          >
            <Image
              source={R.images.igQrCode}
              style={{
                width: 280,
                height: 380,
                resizeMode: "contain",
              }}
            />
            <TouchableOpacity
              style={{ alignItems: "center", justifyContent: "center" }}
              onPress={console.log("Nhấn để lưu ảnh")}
            >
              <IconImage></IconImage>
              <Text
                style={{
                  fontFamily: R.fonts.InterRegular,
                  fontWeight: "300",
                  fontSize: R.fontsize.fontSizeContent,
                  color: R.colors.txtMain,
                }}
              >
                Lưu ảnh
              </Text>
            </TouchableOpacity>
          </View>
        </Pressable>
      </Modal>
    </>
  );
};

export default Debt;
