import {StyleSheet, Text, View, TouchableOpacity, Image} from 'react-native';
import React from 'react';
import R from '../../assets/R';
import styles from './style';
const CardButtonImage = ({
  onPress,
  text = 'Tải ảnh ở đây',
  width,
  height = 150,
  image,
  disabled = false,
}) => {
  return (
    <TouchableOpacity
      style={[
        styles.container_image ,
        {
          width, 
          height,
          borderStyle: 'dashed',
          borderColor: R.colors.gray150,
        },
        disabled && styles.disabled,
      ]}
      onPress={onPress}
      disabled={disabled}
      activeOpacity={0.7}>
      {image ? (
        <Image source={{uri: image}} style={{width: '100%', height: '100%' }} resizeMode="contain" />
      ) : (
        <View style={{justifyContent: 'center', alignItems: 'center'}}>
          <View style={styles.image_placeholder}></View>
          <View>
            <Image source={R.images.icImageDownload} style={styles.image} />
          </View>
          <Text style={styles.placeholder_text}>{text}</Text>
        </View>
      )}
    </TouchableOpacity>
  );
};

export default CardButtonImage;
