// metro.config.js - FIXED: Define defaultConfig trước khi sử dụng
const {getDefaultConfig, mergeConfig} = require('@react-native/metro-config');

/**
 * Metro configuration
 * https://reactnative.dev/docs/metro
 *
 * @type {import('metro-config').MetroConfig}
 */

// FIXME: Phải define defaultConfig TRƯỚC khi sử dụng trong config
const defaultConfig = getDefaultConfig(__dirname);

const config = {
  // FEATURE: Cấu hình transformer để xử lý file SVG
  transformer: {
    babelTransformerPath: require.resolve('react-native-svg-transformer'),
  },
  
  // FEATURE: Cấu hình resolver để nhận diện file SVG
  resolver: {
    // NOTE: Loại bỏ 'svg' khỏi assetExts để không treat như asset
    assetExts: defaultConfig.resolver.assetExts.filter(ext => ext !== 'svg'),
    
    // NOTE: Thêm 'svg' vào sourceExts để treat như source code
    sourceExts: [...defaultConfig.resolver.sourceExts, 'svg'],
  },
};

module.exports = mergeConfig(defaultConfig, config);