import React from "react";
import {
  Text,
  View,
  StyleSheet,
  FlatList,
} from "react-native";
import R from "../../assets/R";
import Header from "../../components/Header/Header";
import Button from "../../components/Button";
import ItemNav from "./item";
import RegistrationModal from "./modal";

const OutpatientInfomationView = (props) => {
  const { dataTitle, dataList,isModalVisible,
    onOpenRegistrationModal,
    onCloseModal,
    onNavigateToOther,
    onSubmitRegistration,} = props;
  const renderItem = ({ item, index }) => {
    return <ItemNav item={item} />;
  };
  const keyExtractor = (item, index) => `history-item-${index}`;

  return (
    <View style={styles.container}>
       <Header title={"Thông tin ngoại trú"} isBack />
    <View style={styles.container}>
      <View style={styles.container}>
        <View style={styles.fixedInfoSection}>
          <Text style={styles.text}>Thông tin tạm trú</Text>
          <Text style={[styles.text, styles.addressText]}>
            134/44/9 Nguyên xá, Bắc Từ Liêm, Hà Nội
          </Text>
          <Text style={[styles.text, styles.addressText, {fontFamily: R.fonts.InterMedium, fontWeight: '600'}]}>
            Thời gian bắt đầu cư chú: <Text style={{fontFamily: R.fonts.InterRegular}}>20/11/2024</Text>
          </Text>
          <Text style={[styles.text, styles.historyTitle]}>
            Lịch sử đăng ký
          </Text>
        </View>

        <FlatList
          style={styles.scrollableList}
          data={dataList}
          renderItem={renderItem}
          keyExtractor={keyExtractor}
          showsVerticalScrollIndicator={false}
          contentContainerStyle={styles.flatListContent}
          removeClippedSubviews={true}
          maxToRenderPerBatch={5}
          windowSize={5}
          initialNumToRender={3}
        />

        <View style={styles.buttonSection}>
          <Button
            title={"Đăng kí mới"}
            fontSize={R.fontsize.fontSizeHeader}
            fontWeight={'300'}
            textColor={R.colors.white}
            fontFamily={R.fonts.InterRegular}
            backgroundColor={R.colors.blue500}
            borderRadius={10}
            height={35}
            onPress={onOpenRegistrationModal}
          />
        </View>
      </View>
        <RegistrationModal
        visible={isModalVisible}
        onClose={onCloseModal}
        onNavigateToOther={onNavigateToOther}
        onSubmit={onSubmitRegistration}
      />
    </View>
    </View>
  );
};

export default OutpatientInfomationView;

const styles = StyleSheet.create({
  
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  fixedInfoSection: {
    paddingHorizontal: 15,
    paddingVertical: 10,
    backgroundColor: R.colors.white,
  },
  scrollableList: {
    flex: 1,
    paddingHorizontal: 15,
  },
  flatListContent: {
    paddingTop: 10,
    paddingBottom: 10,
  },
  buttonSection: {
    paddingHorizontal: 15,
    paddingVertical: 15,
    backgroundColor: R.colors.white,
  },
  text: {
    color: R.colors.blue500,
    fontFamily: R.fonts.InterSemiBold,
    fontWeight: "500",
    fontSize: R.fontsize.fontsSize14,
  },
  addressText: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
    fontWeight: "400",
  },
  historyTitle: {
    fontSize: R.fontsize.fontsSize14,
    
   
  },
});