import { StyleSheet } from "react-native";
import R from "../../assets/R";
const styles = StyleSheet.create({
    container: {
      flex: 1,
      backgroundColor: R.colors.white,
    },
  
    container_tab_bar: {
      marginVertical: 10,
      marginHorizontal: 12,
    },
  
    tab_button: {
      paddingHorizontal: 5,
      paddingVertical: 5,
      marginHorizontal: 3,
      borderRadius: 10,
      backgroundColor: R.colors.gray400,
      width: 90,
      alignItems: "center",
      justifyContent: "center",
    },
    tab_button_active: {
      backgroundColor: R.colors.blue500,
    },
    tab_button_text: {
      fontFamily: R.fonts.InterSemiBold,
      fontWeight: "500",
      fontSize: R.fontsize.fontsSize12,
      color: R.colors.white,
    },
  
    notification_item: {
      backgroundColor: R.colors.white,
      paddingVertical: 10,
      marginHorizontal: 15,
      marginBottom: 10,
      paddingHorizontal: 15,
      borderRadius: 10,
      flexDirection: "row",
      alignItems: "flex-start",
      shadowColor: R.colors.black,
      shadowOffset: {
        width: 0,
        height: 2,
      },
      shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
      shadowRadius: 1,
      elevation: Platform.OS === 'ios' ? 1 : 2,
    },
    notification_content: {
      flex: 1,
      overflow: 'hidden',
      backgroundColor: R.colors.white,
    },
    notification_title: {
      fontSize: R.fontsize.fontsSize14,
      fontWeight: "600",
      fontFamily: R.fonts.InterMedium,
      color: R.colors.black,
      numberOfLines: 1,
      ellipsizeMode: "tail",
      lineHeight: 16
    },
    text_content: {
      fontSize: R.fontsize.fontsSize12,
      fontWeight: "400",
      fontFamily: R.fonts.InterRegular,
      color: R.colors.black,
      lineHeight: 16
    },
    content_container: {
      flex: 1,
      backgroundColor: R.colors.white,
    },
  });
  
  export default styles;