import React from 'react';
import {
  View,
  FlatList,
  SafeAreaView,
  Text,
  ActivityIndicator,
} from 'react-native';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import I18n from '../../helper/i18/i18n';
import ItemView from './item_view';
import styles from './style';
import ItemCalendar from '../roll_call/item_calendar';
const ExamScheduleView = props => {
  const {dataExamSchedule} = props;
  const renderContent = ({item}) => {
    return <ItemView item={item} />;
  };

  const renderBody = () => {
    return (
      <View style={styles.body}>
        <ItemCalendar />
        <View style={styles.flatlist}>
          <FlatList
            data={dataExamSchedule}
            renderItem={renderContent}
            keyExtractor={item => item.id}
            contentContainerStyle={styles.content_container}
            showsVerticalScrollIndicator={false}
            ListEmptyComponent={() => (
              <View style={styles.content_container}>
                <ActivityIndicator
                  size="large"
                  color={R.colors.main}
                  animating
                />
                <Text style={styles.text_empty}>Không có dữ liệu</Text>
              </View>
            )}
          />
        </View>
      </View>
    );
  };
  return (
    <View style={styles.container}>
      <Header isBack title={I18n.t('ExamSchedule')} />
      {renderBody()}
    </View>
  );
};

export default ExamScheduleView;
